package com.bizvane.couponfacade.models.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 券冲正VO
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class CouponReversalRequestVO implements Serializable {

  private static final long serialVersionUID = 1L;

      @io.swagger.annotations.ApiModelProperty(value = "品牌code", name = "brandCode", required = false,example = "")
      private String brandCode;

      private Long sysCompanyId;

      @io.swagger.annotations.ApiModelProperty(value = "券号", name = "couponCode", required = false,example = "")
      private String couponCode;

      @io.swagger.annotations.ApiModelProperty(value = "线下会员id", name = "erpId", required = false, example = "")
      private String erpId;

      @io.swagger.annotations.ApiModelProperty(value = "订单号", name = "orderNo", required = false, example = "")
      private String orderNo;

      @io.swagger.annotations.ApiModelProperty(value = "门店code", name = "storeCode", required = false,example = "")
      private String storeCode;

}
