package com.bizvane.core.facade.models.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysThirdToCrmLogAddBO implements Serializable {

    private static final long serialVersionUID = 9206841961532910406L;

    /**
     * 只读. 企业id. sys_company_id
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "企业id",name = "sysCompanyId")
    private Long sysCompanyId;

    /**
     * 只读. 品牌id. sys_brand_id
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "品牌id",name = "sysBrandId")
    private Long sysBrandId;

    /**
     * 只读. 第三方渠道appi. third_appid
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "第三方渠道appi",name = "thirdAppid")
    private String thirdAppid;

    /**
     * 只读. 第三方类型(枚举). third_type
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "第三方类型(枚举)",name = "thirdType")
    private String thirdType;

    /**
     * 只读. 第三方类型名称. third_type_name
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "第三方类型名称",name = "thirdTypeName")
    private String thirdTypeName;

    /**
     * 只读. 业务类型(枚举). business_type
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "业务类型(枚举)",name = "businessType")
    private String businessType;

    /**
     * 只读. 业务类型名称. business_type_name
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "业务类型名称",name = "businessTypeName")
    private String businessTypeName;

    /**
     * 只读. 身份信息唯一标识. unique_code
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "身份信息唯一标识",name = "uniqueCode")
    private String uniqueCode;

    /**
     * 只读. 业务唯一标识单据号. business_no
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "业务唯一标识单据号",name = "businessNo")
    private String businessNo;

    /**
     * 只读. 链路Id. link_trace_id
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "链路Id",name = "linkTraceId")
    private String linkTraceId;

    /**
     * 只读. 请求参数. param
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "请求参数",name = "param")
    private String param;

    /**
     * 只读. 返回结果. result
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "返回结果",name = "result")
    private String result;

    /**
     * 只读. 日志级别(info,erro). log_level
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "日志级别(info,erro)",name = "logLevel")
    private String logLevel;

    /**
     * 只读. 同步状态(1成功，0失败). flag_status
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "同步状态(1成功，0失败)",name = "flagStatus")
    private Boolean flagStatus;

    /**
     * 只读. 失败原因. fail_reson
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "失败原因",name = "failReson")
    private String failReson;

    /**
     * 只读. 日志时间. log_date
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "日志时间",name = "logDate")
    private Date logDate;
}
