/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.service.impl;

import com.bizvane.content.api.config.OSSProperties;
import com.bizvane.content.api.model.dto.oss.FIleUploadResponseVO;
import com.bizvane.content.api.model.dto.oss.TempCredentialDTO;
import com.bizvane.content.api.service.OSSClientService;
import com.bizvane.content.api.service.UploadBusinessService;
import com.bizvane.content.api.service.impl.BuinessCacheComponent;
import com.bizvane.content.domain.enums.FileTypeEnum;
import com.bizvane.content.domain.util.ResponseUtil;
import com.bizvane.content.domain.util.UID;
import com.bizvane.utils.responseinfo.ResponseData;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.utils.Md5Utils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import sun.net.util.URLUtil;

@Service
public class UploadBusinessServiceImpl
implements UploadBusinessService {
    private static final Logger log = LoggerFactory.getLogger(UploadBusinessServiceImpl.class);
    private final BuinessCacheComponent buinessCacheComponent;
    private final OSSClientService ossClientService;
    private final OSSProperties ossProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseData<FIleUploadResponseVO> handleFileUpload(MultipartFile file, Integer fileType, Boolean only) {
        FileTypeEnum fileTypeEnum = FileTypeEnum.valueOfType((Integer)fileType);
        TempCredentialDTO tempCredential = this.buinessCacheComponent.getTempCredential(fileTypeEnum);
        COSClient cosClient = this.ossClientService.createSimple(tempCredential);
        String bucketName = this.ossProperties.getQcloud().getBucketName();
        try {
            if (BooleanUtils.isTrue((Boolean)only)) {
                FIleUploadResponseVO fIleUploadResponseVO = this.simpleFileUploadOnly(file, cosClient, bucketName, fileTypeEnum);
                ResponseData responseData = ResponseUtil.success((Object)fIleUploadResponseVO);
                return responseData;
            }
            FIleUploadResponseVO fIleUploadResponseVO = this.simpleFileUpload(file, cosClient, bucketName, fileTypeEnum);
            ResponseData responseData = ResponseUtil.success((Object)fIleUploadResponseVO);
            return responseData;
        }
        catch (IOException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e);
        }
        finally {
            cosClient.shutdown();
        }
        return ResponseUtil.fail((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
    }

    private FIleUploadResponseVO simpleFileUpload(MultipartFile file, COSClient cosClient, String bucketName, FileTypeEnum fileTypeEnum) throws IOException {
        String suffix = this.getExtension(file);
        String fileName = UID.getUid() + suffix;
        String key = fileTypeEnum.getPrefix() + fileName;
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, file.getInputStream(), null);
        try {
            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
            FIleUploadResponseVO fIleUploadResponseVO = new FIleUploadResponseVO();
            fIleUploadResponseVO.setKey(key);
            fIleUploadResponseVO.setRequestId(putObjectResult.getRequestId());
            fIleUploadResponseVO.setType(fileTypeEnum.getType());
            URL fileURL = cosClient.getObjectUrl(bucketName, key);
            fIleUploadResponseVO.setFileUrl(URLUtil.urlNoFragString(fileURL));
            return fIleUploadResponseVO;
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FIleUploadResponseVO simpleFileUploadOnly(MultipartFile file, COSClient cosClient, String bucketName, FileTypeEnum fileTypeEnum) throws IOException {
        String suffix = this.getExtension(file);
        String fileName = UID.getUid() + suffix;
        File localFile = File.createTempFile(System.getProperty("user.dir") + "/" + fileName, suffix);
        file.transferTo(localFile);
        String key = fileTypeEnum.getPrefix() + Md5Utils.md5AsBase64((File)localFile) + suffix;
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        try {
            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
            FIleUploadResponseVO fIleUploadResponseVO = new FIleUploadResponseVO();
            fIleUploadResponseVO.setKey(key);
            fIleUploadResponseVO.setRequestId(putObjectResult.getRequestId());
            fIleUploadResponseVO.setType(fileTypeEnum.getType());
            URL fileURL = cosClient.getObjectUrl(bucketName, key);
            fIleUploadResponseVO.setFileUrl(URLUtil.urlNoFragString(fileURL));
            FIleUploadResponseVO fIleUploadResponseVO2 = fIleUploadResponseVO;
            return fIleUploadResponseVO2;
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        finally {
            if (localFile.exists()) {
                localFile.delete();
            }
        }
        return null;
    }

    private String getExtension(MultipartFile file) {
        String extension = FilenameUtils.getExtension((String)file.getOriginalFilename());
        if (StringUtils.isBlank((CharSequence)extension)) {
            return "";
        }
        return ".".concat(extension);
    }

    public UploadBusinessServiceImpl(BuinessCacheComponent buinessCacheComponent, OSSClientService ossClientService, OSSProperties ossProperties) {
        this.buinessCacheComponent = buinessCacheComponent;
        this.ossClientService = ossClientService;
        this.ossProperties = ossProperties;
    }
}

