/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.content.api.service.FitmentService;
import com.bizvane.content.api.util.ConvertUtil;
import com.bizvane.content.api.util.IPageUtil;
import com.bizvane.content.domain.model.entity.ContentFitmentPO;
import com.bizvane.content.domain.service.IContentFitmentService;
import com.bizvane.content.domain.util.ResponseUtil;
import com.bizvane.content.domain.util.UID;
import com.bizvane.content.feign.vo.OptUserVO;
import com.bizvane.content.feign.vo.PageVO;
import com.bizvane.content.feign.vo.fitment.FitmentAddRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentAddResponseVO;
import com.bizvane.content.feign.vo.fitment.FitmentDeleteRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentDeleteResponseVO;
import com.bizvane.content.feign.vo.fitment.FitmentSelectDetailRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentSelectDetailResponseVO;
import com.bizvane.content.feign.vo.fitment.FitmentSelectPageRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentUpdateRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentUpdateResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FitmentServiceImpl
implements FitmentService {
    private final IContentFitmentService contentFitmentService;

    @Override
    public ResponseData<FitmentSelectDetailResponseVO> selectDetail(FitmentSelectDetailRequestVO requestVO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(requestVO.getFitmentType() != null, ContentFitmentPO::getFitmentType, (Object)requestVO.getFitmentType())).eq(requestVO.getChannelType() != null, ContentFitmentPO::getChannelType, (Object)requestVO.getChannelType())).eq(ContentFitmentPO::getContentFitmentCode, (Object)requestVO.getFitmentType())).last("limit 1");
        ContentFitmentPO contentFitmentPO = (ContentFitmentPO)this.contentFitmentService.getOne((Wrapper)queryWrapper);
        FitmentSelectDetailResponseVO fitmentSelectDetailResponseVO = ConvertUtil.po2vo(contentFitmentPO);
        return ResponseUtil.success((Object)fitmentSelectDetailResponseVO);
    }

    @Override
    public ResponseData<PageInfo<FitmentSelectDetailResponseVO>> selectPage(FitmentSelectPageRequestVO requestVO) {
        Page page = new Page();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContentFitmentPO::getChannelType, (Object)requestVO.getChannelType())).eq(ContentFitmentPO::getFitmentType, (Object)requestVO.getFitmentType())).like(StringUtils.isNotBlank((CharSequence)requestVO.getHeaderName()), ContentFitmentPO::getHeaderName, (Object)requestVO.getHeaderName());
        Page fitmentPOPage = (Page)this.contentFitmentService.page((IPage)page, (Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)fitmentPOPage.getRecords())) {
            return new ResponseData(new IPageUtil((PageVO)requestVO).getPageInfo());
        }
        List resultList = fitmentPOPage.getRecords().stream().map(appletFitmentPO -> ConvertUtil.po2vo(appletFitmentPO)).collect(Collectors.toList());
        PageInfo pageResult = new IPageUtil(fitmentPOPage, resultList).getPageInfo();
        return ResponseUtil.success(pageResult);
    }

    @Override
    public ResponseData<FitmentAddResponseVO> addFitment(FitmentAddRequestVO requestVO) {
        ContentFitmentPO contentFitmentPO = new ContentFitmentPO();
        contentFitmentPO.setFitmentType(requestVO.getFitmentType());
        contentFitmentPO.setChannelType(requestVO.getChannelType());
        contentFitmentPO.setHeaderName(requestVO.getHeaderName());
        contentFitmentPO.setInfo(requestVO.getInfoJson());
        contentFitmentPO.setStatus(requestVO.getStatus());
        contentFitmentPO.setBgColor(requestVO.getBgColor());
        contentFitmentPO.setCreateUserName(requestVO.getOptUserName());
        contentFitmentPO.setCreateUserCode(requestVO.getOptUserCode());
        contentFitmentPO.setContentFitmentCode(UID.getUid());
        Boolean result = this.contentFitmentService.save((Object)contentFitmentPO);
        FitmentAddResponseVO responseVO = new FitmentAddResponseVO();
        responseVO.setContentFitmentCode(contentFitmentPO.getContentFitmentCode());
        responseVO.setOptStatus(result.booleanValue());
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<FitmentUpdateResponseVO> updateFitment(FitmentUpdateRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(ContentFitmentPO::getBgColor, (Object)requestVO.getBgColor())).set(ContentFitmentPO::getHeaderName, (Object)requestVO.getHeaderName())).set(ContentFitmentPO::getInfo, (Object)requestVO.getInfoJson())).set(ContentFitmentPO::getStatus, (Object)requestVO.getStatus())).set(ContentFitmentPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(ContentFitmentPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(ContentFitmentPO::getContentFitmentCode, (Object)requestVO.getContentFitmentCode());
        Boolean result = this.contentFitmentService.update((Wrapper)updateWrapper);
        FitmentUpdateResponseVO responseVO = new FitmentUpdateResponseVO();
        responseVO.setContentFitmentCode(responseVO.getContentFitmentCode());
        responseVO.setOptStatus(result.booleanValue());
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<FitmentDeleteResponseVO> deleteFitment(FitmentDeleteRequestVO requestVO) {
        boolean result = this.contentFitmentService.deleteByCode((OptUserVO)requestVO, requestVO.getAppletFitmentCode());
        FitmentDeleteResponseVO responseVO = new FitmentDeleteResponseVO();
        responseVO.setOptStatus(result);
        return ResponseUtil.success((Object)responseVO);
    }

    public FitmentServiceImpl(IContentFitmentService contentFitmentService) {
        this.contentFitmentService = contentFitmentService;
    }
}

