/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.controller;

import com.bizvane.content.api.service.MaterialLabelService;
import com.bizvane.content.domain.util.AssertUtil;
import com.bizvane.content.feign.api.MaterialLabelFeign;
import com.bizvane.content.feign.vo.OptUserVO;
import com.bizvane.content.feign.vo.material.MaterialLabelAddRequestVO;
import com.bizvane.content.feign.vo.material.MaterialLabelAddResponseVO;
import com.bizvane.content.feign.vo.material.MaterialLabelDeleteRequestVO;
import com.bizvane.content.feign.vo.material.MaterialLabelDeleteResponseVO;
import com.bizvane.content.feign.vo.material.MaterialLabelDetailRequestVO;
import com.bizvane.content.feign.vo.material.MaterialLabelDetailResponseVO;
import com.bizvane.content.feign.vo.material.MaterialLabelPageRequestVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"materialLabel"})
public class MaterialLabelController
implements MaterialLabelFeign {
    private final MaterialLabelService materialLabelService;

    public ResponseData<MaterialLabelDetailResponseVO> selectMaterialLabelDetail(@RequestBody MaterialLabelDetailRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getContentMaterialLabelCode(), (String)"\u7d20\u6750\u6807\u7b7ecode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.materialLabelService.selectMaterialLabelDetail(requestVO);
    }

    public ResponseData<PageInfo<MaterialLabelDetailResponseVO>> selectMaterialLabelPage(@RequestBody MaterialLabelPageRequestVO requestVO) {
        return this.materialLabelService.selectMaterialLabelPage(requestVO);
    }

    public ResponseData<MaterialLabelDeleteResponseVO> deleteMaterialLabel(@RequestBody MaterialLabelDeleteRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getContentMaterialLabelCode(), (String)"\u7d20\u6750\u6807\u7b7ecode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.materialLabelService.deleteMaterialLabel(requestVO);
    }

    public ResponseData<MaterialLabelAddResponseVO> addMaterialLabel(@RequestBody MaterialLabelAddRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getLabelName(), (String)"\u7d20\u6750\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        return this.materialLabelService.addMaterialLabel(requestVO);
    }

    public MaterialLabelController(MaterialLabelService materialLabelService) {
        this.materialLabelService = materialLabelService;
    }
}

