/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.controller;

import com.bizvane.content.api.service.MaterialService;
import com.bizvane.content.domain.util.AssertUtil;
import com.bizvane.content.feign.api.MaterialFeign;
import com.bizvane.content.feign.enums.material.MaterialTypeEnum;
import com.bizvane.content.feign.vo.OptUserVO;
import com.bizvane.content.feign.vo.material.MaterialDeleteRequestVO;
import com.bizvane.content.feign.vo.material.MaterialDeleteResponseVO;
import com.bizvane.content.feign.vo.material.MaterialDetailRequestVO;
import com.bizvane.content.feign.vo.material.MaterialDetailResponseVO;
import com.bizvane.content.feign.vo.material.MaterialPageRequestVO;
import com.bizvane.content.feign.vo.material.MaterialSaveRequestVO;
import com.bizvane.content.feign.vo.material.MaterialSaveResponseVO;
import com.bizvane.content.feign.vo.material.MaterialUpdateRequestVO;
import com.bizvane.content.feign.vo.material.MaterialUpdateResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"material"})
public class MaterialController
implements MaterialFeign {
    private final MaterialService materialService;

    public ResponseData<MaterialDetailResponseVO> selectMaterialDetail(@RequestBody MaterialDetailRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getContentMaterialCode(), (String)"\u7d20\u6750\u4e1a\u52a1code\u4e0d\u80fd\u4e3a\u7a7a");
        return this.materialService.selectMaterialDetail(requestVO);
    }

    public ResponseData<PageInfo<MaterialDetailResponseVO>> selectMaterialPage(@RequestBody MaterialPageRequestVO requestVO) {
        AssertUtil.notNull((Object)requestVO.getType(), (String)"\u7d20\u6750\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)MaterialTypeEnum.containsKey((Integer)requestVO.getType()), (String)"\u7d20\u6750\u7c7b\u578b\u4e0d\u5b58\u5728");
        return this.materialService.selectMaterialPage(requestVO);
    }

    public ResponseData<MaterialSaveResponseVO> saveMaterial(@RequestBody MaterialSaveRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((Object)ObjectUtils.allNotNull((Object[])new Object[]{requestVO.getCoverImage(), requestVO.getFileUrl(), requestVO.getTitle()}), (String)"\u5c01\u9762,\u6587\u4ef6,\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getType(), (String)"\u7d20\u6750\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)MaterialTypeEnum.containsKey((Integer)requestVO.getType()), (String)"\u7d20\u6750\u7c7b\u578b\u4e0d\u5b58\u5728");
        AssertUtil.notEmpty((Collection)requestVO.getMaterialLabelCodeList(), (String)"\u7d20\u6750\u6807\u7b7eList\u4e0d\u80fd\u4e3a\u7a7a");
        return this.materialService.saveMaterial(requestVO);
    }

    public ResponseData<MaterialUpdateResponseVO> updateMaterial(@RequestBody MaterialUpdateRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((Object)ObjectUtils.allNotNull((Object[])new Object[]{requestVO.getCoverImage(), requestVO.getFileUrl(), requestVO.getTitle(), requestVO.getMaterialCode()}), (String)"\u5c01\u9762,\u6587\u4ef6,\u6807\u9898,\u7d20\u6750code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getType(), (String)"\u7d20\u6750\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)MaterialTypeEnum.containsKey((Integer)requestVO.getType()), (String)"\u7d20\u6750\u7c7b\u578b\u4e0d\u5b58\u5728");
        AssertUtil.notEmpty((Collection)requestVO.getMaterialLabelCodeList(), (String)"\u7d20\u6750\u6807\u7b7eList\u4e0d\u80fd\u4e3a\u7a7a");
        return this.materialService.updateMaterial(requestVO);
    }

    public ResponseData<MaterialDeleteResponseVO> deleteMaterial(@RequestBody MaterialDeleteRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getContentMaterialCode(), (String)"\u7d20\u6750code\u4e0d\u80fd\u4e3a\u7a7a");
        return this.materialService.deleteMaterial(requestVO);
    }

    public MaterialController(MaterialService materialService) {
        this.materialService = materialService;
    }
}

