/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.controller;

import com.bizvane.content.api.service.FitmentService;
import com.bizvane.content.domain.util.AssertUtil;
import com.bizvane.content.feign.api.FitmentFeign;
import com.bizvane.content.feign.enums.fitment.FitmentTypeEnums;
import com.bizvane.content.feign.vo.OptUserVO;
import com.bizvane.content.feign.vo.fitment.FitmentAddRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentAddResponseVO;
import com.bizvane.content.feign.vo.fitment.FitmentDeleteRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentDeleteResponseVO;
import com.bizvane.content.feign.vo.fitment.FitmentSelectDetailRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentSelectDetailResponseVO;
import com.bizvane.content.feign.vo.fitment.FitmentSelectPageRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentUpdateRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentUpdateResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fitment"})
public class FitmentController
implements FitmentFeign {
    private final FitmentService fitmentService;

    public ResponseData<FitmentSelectDetailResponseVO> selectDetail(@RequestBody FitmentSelectDetailRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getAppletFitmentCode(), (String)"\u88c5\u4feecode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.fitmentService.selectDetail(requestVO);
    }

    public ResponseData<PageInfo<FitmentSelectDetailResponseVO>> selectPage(@RequestBody FitmentSelectPageRequestVO requestVO) {
        AssertUtil.notNull((Object)requestVO.getFitmentType(), (String)"\u9875\u9762\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)FitmentTypeEnums.containsKey((Integer)requestVO.getFitmentType()), (String)"\u9875\u9762\u7c7b\u578b\u4e0d\u5b58\u5728");
        return this.fitmentService.selectPage(requestVO);
    }

    public ResponseData<FitmentAddResponseVO> addFitment(@RequestBody FitmentAddRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.judge((Boolean)ObjectUtils.allNotNull((Object[])new Object[]{requestVO.getBgColor(), requestVO.getHeaderName(), requestVO.getInfoJson(), requestVO.getStatus(), requestVO.getFitmentType(), requestVO.getChannelType()}), (String)"\u4e1a\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return this.fitmentService.addFitment(requestVO);
    }

    public ResponseData<FitmentUpdateResponseVO> updateFitment(@RequestBody FitmentUpdateRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.judge((Boolean)ObjectUtils.allNotNull((Object[])new Object[]{requestVO.getBgColor(), requestVO.getHeaderName(), requestVO.getInfoJson(), requestVO.getStatus(), requestVO.getFitmentType(), requestVO.getChannelType()}), (String)"\u4e1a\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getContentFitmentCode(), (String)"\u88c5\u4feecode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.fitmentService.updateFitment(requestVO);
    }

    public ResponseData<FitmentDeleteResponseVO> deleteFitment(@RequestBody FitmentDeleteRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getAppletFitmentCode(), (String)"\u88c5\u4feecode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.fitmentService.deleteFitment(requestVO);
    }

    public FitmentController(FitmentService fitmentService) {
        this.fitmentService = fitmentService;
    }
}

