/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.config;

import com.bizvane.content.api.config.OSSProperties;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OSSProperties.class})
public class OSSAutoConfiguration {
    @Bean
    @ConditionalOnProperty(name={"oss.qcloud.enabled"}, havingValue="true", matchIfMissing=true)
    public COSClient cosClient(OSSProperties ossProperties) {
        OSSProperties.QcloudCosProperties properties = ossProperties.getQcloud();
        String secretId = properties.getSecretId();
        String secretKey = properties.getSecretKey();
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region region = new Region(properties.getRegion());
        ClientConfig clientConfig = new ClientConfig(region);
        return new COSClient((COSCredentials)cred, clientConfig);
    }
}

