/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.service.impl;

import com.bizvane.content.api.model.dto.oss.CannedAccessControl;
import com.bizvane.content.api.model.dto.oss.PreUploadDTO;
import com.bizvane.content.api.model.dto.oss.TempCredentialDTO;
import com.bizvane.content.api.model.dto.oss.UploadResultDTO;
import com.bizvane.content.api.service.OSSClientService;
import com.bizvane.content.api.service.UploadService;
import com.bizvane.content.domain.enums.FileTypeEnum;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.model.ResponseHeaderOverrides;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UploadServiceImpl
implements UploadService {
    private static final Logger log = LoggerFactory.getLogger(UploadServiceImpl.class);
    private final OSSClientService ossClientService;

    @Override
    public PreUploadDTO generatePreUploadInfo(int type) {
        String prefix = type == 1 ? "image/" : "doc/";
        String suffix = type == 1 ? ".png" : "";
        String key = prefix + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "/";
        key = key + RandomStringUtils.randomAlphanumeric((int)6) + suffix;
        return this.ossClientService.generatePreUploadInfo(key, 600L, HttpMethodName.PUT);
    }

    @Override
    public TempCredentialDTO getTempCredential(int type) {
        String resource = type == 1 ? "image/*" : "doc/*";
        try {
            return this.ossClientService.generateTempCredential(Collections.singletonList("/" + resource), false);
        }
        catch (IOException e) {
            log.error("Failed to get temporary credentials", (Throwable)e);
            throw new RuntimeException("Failed to get temporary credentials");
        }
    }

    @Override
    public String generateDownloadPresignedUrl(String key, String fileName) {
        ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides();
        try {
            fileName = URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        responseHeaders.setContentDisposition("attachment;filename=" + fileName);
        responseHeaders.setCacheControl("no-cache");
        return this.ossClientService.generateDownloadPresignedUrl(key, 600L, null);
    }

    @Override
    public TempCredentialDTO getTempCredential(FileTypeEnum fileTypeEnum) {
        String resource = fileTypeEnum.getResouce();
        try {
            return this.ossClientService.generateTempCredential(Collections.singletonList("/" + resource), false);
        }
        catch (IOException e) {
            log.error("Failed to get temporary credentials", (Throwable)e);
            throw new RuntimeException("Failed to get temporary credentials");
        }
    }

    @Override
    public UploadResultDTO upload(int type, InputStream is, boolean isPublicRead) {
        String prefix = type == 1 ? "image/" : "doc/";
        String suffix = type == 1 ? ".png" : "";
        String key = prefix + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "/";
        key = key + RandomStringUtils.randomAlphanumeric((int)6) + suffix;
        CannedAccessControl control = isPublicRead ? CannedAccessControl.PublicRead : CannedAccessControl.Default;
        return this.ossClientService.upload(key, is, control);
    }

    public UploadServiceImpl(OSSClientService ossClientService) {
        this.ossClientService = ossClientService;
    }
}

