/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.service.impl;

import com.bizvane.content.api.config.OSSProperties;
import com.bizvane.content.api.model.dto.oss.CannedAccessControl;
import com.bizvane.content.api.model.dto.oss.PreUploadDTO;
import com.bizvane.content.api.model.dto.oss.TempCredentialDTO;
import com.bizvane.content.api.model.dto.oss.UploadResultDTO;
import com.bizvane.content.api.service.OSSClientService;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicSessionCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.ResponseHeaderOverrides;
import com.qcloud.cos.region.Region;
import com.tencent.cloud.CosStsClient;
import com.tencent.cloud.Policy;
import com.tencent.cloud.Response;
import com.tencent.cloud.Statement;
import com.tencent.cloud.cos.util.Jackson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class QcloudOSSClientServiceImpl
implements OSSClientService {
    private final COSClient cosClient;
    private OSSProperties.QcloudCosProperties cosProperties;

    @Autowired
    public void setCosProperties(OSSProperties ossProperties) {
        this.cosProperties = ossProperties.getQcloud();
    }

    @Override
    public PreUploadDTO generatePreUploadInfo(String key, long expiration, HttpMethodName method) {
        PreUploadDTO result = new PreUploadDTO();
        URL url = this.cosClient.generatePresignedUrl(this.cosProperties.getBucketName(), key, Date.from(Instant.now().plusSeconds(expiration)), method);
        result.setDomain(this.cosProperties.getDomain());
        result.setKey(key);
        result.setUrl(url.toString());
        return result;
    }

    @Override
    public TempCredentialDTO generateTempCredential(@NonNull List<String> grantResources, boolean onlyRead) throws IOException {
        Statement statement;
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("secretId", this.cosProperties.getSecretId());
        config.put("secretKey", this.cosProperties.getSecretKey());
        Policy policy = new Policy();
        config.put("durationSeconds", 1800);
        config.put("bucket", this.cosProperties.getBucketName());
        config.put("region", this.cosProperties.getRegion());
        String prefix = "qcs::cos:" + this.cosProperties.getRegion() + ":uid/" + this.cosProperties.getAppId() + ":" + this.cosProperties.getBucketName();
        String[] resources = (String[])grantResources.stream().map(resource -> prefix + resource).toArray(String[]::new);
        if (!onlyRead) {
            statement = new Statement();
            statement.setEffect("allow");
            statement.addActions(new String[]{"cos:PutObject", "cos:PostObject"});
            statement.addResources(resources);
            policy.addStatement(statement);
        }
        statement = new Statement();
        statement.setEffect("allow");
        statement.addActions(new String[]{"cos:GetObject"});
        statement.addResources(resources);
        policy.addStatement(statement);
        config.put("policy", Jackson.toJsonPrettyString((Object)policy));
        Response response = CosStsClient.getCredential(config);
        System.out.println(response.credentials.tmpSecretId);
        System.out.println(response.credentials.tmpSecretKey);
        System.out.println(response.credentials.sessionToken);
        TempCredentialDTO result = new TempCredentialDTO();
        result.setTmpSecretId(response.credentials.tmpSecretId);
        result.setTmpSecretKey(response.credentials.tmpSecretKey);
        result.setSessionToken(response.credentials.sessionToken);
        result.setExpiration(response.expiration);
        result.setStartTime(response.startTime);
        result.setExpiredTime(response.expiredTime);
        return result;
    }

    @Override
    public void setObjectAclCannedAccess(String key, CannedAccessControl control) {
        this.cosClient.setObjectAcl(this.cosProperties.getBucketName(), key, this.convert(control));
    }

    @Override
    public String generateDownloadPresignedUrl(String key, long expiration, ResponseHeaderOverrides responseHeaders) {
        GeneratePresignedUrlRequest req = new GeneratePresignedUrlRequest(this.cosProperties.getBucketName(), key, HttpMethodName.GET);
        if (responseHeaders != null) {
            req.setResponseHeaders(responseHeaders);
        }
        Date expirationDate = new Date(System.currentTimeMillis() + expiration * 1000L);
        req.setExpiration(expirationDate);
        URL url = this.cosClient.generatePresignedUrl(req);
        return url.toString();
    }

    @Override
    public COSClient createSimple(TempCredentialDTO tempCredential) {
        String tmpSecretId = tempCredential.getTmpSecretId();
        String tmpSecretKey = tempCredential.getTmpSecretKey();
        String sessionToken = tempCredential.getSessionToken();
        BasicSessionCredentials cred = new BasicSessionCredentials(tmpSecretId, tmpSecretKey, sessionToken);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setRegion(new Region(this.cosProperties.getRegion()));
        clientConfig.setSocketTimeout(30000);
        clientConfig.setConnectionTimeout(30000);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    @Override
    public UploadResultDTO upload(String key, InputStream is, CannedAccessControl control) {
        PutObjectRequest request = new PutObjectRequest(this.cosProperties.getBucketName(), key, is, null);
        request.setCannedAcl(this.convert(control));
        this.cosClient.putObject(request);
        UploadResultDTO result = new UploadResultDTO();
        result.setKey(key);
        result.setDomain(this.cosProperties.getDomain());
        if (this.cosProperties.getDomain().endsWith("/")) {
            result.setUrl(this.cosProperties.getDomain() + key);
        } else {
            result.setUrl(this.cosProperties.getDomain() + "/" + key);
        }
        return result;
    }

    private CannedAccessControlList convert(CannedAccessControl accessControl) {
        switch (accessControl) {
            case Private: {
                return CannedAccessControlList.Private;
            }
            case PublicRead: {
                return CannedAccessControlList.PublicRead;
            }
            case PublicReadWrite: {
                return CannedAccessControlList.PublicReadWrite;
            }
            case Default: {
                return CannedAccessControlList.Default;
            }
        }
        throw new IllegalArgumentException("Unknown access control: " + (Object)((Object)accessControl));
    }

    public QcloudOSSClientServiceImpl(COSClient cosClient) {
        this.cosClient = cosClient;
    }
}

