/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.content.api.service.MaterialService;
import com.bizvane.content.api.util.ConvertUtil;
import com.bizvane.content.api.util.IPageUtil;
import com.bizvane.content.domain.model.entity.ContentMaterialLabelRelPO;
import com.bizvane.content.domain.model.entity.ContentMaterialPO;
import com.bizvane.content.domain.service.IContentMaterialLabelRelService;
import com.bizvane.content.domain.service.IContentMaterialLabelService;
import com.bizvane.content.domain.service.IContentMaterialService;
import com.bizvane.content.domain.util.ResponseUtil;
import com.bizvane.content.domain.util.UID;
import com.bizvane.content.feign.vo.OptUserVO;
import com.bizvane.content.feign.vo.material.MaterialDeleteRequestVO;
import com.bizvane.content.feign.vo.material.MaterialDeleteResponseVO;
import com.bizvane.content.feign.vo.material.MaterialDetailRequestVO;
import com.bizvane.content.feign.vo.material.MaterialDetailResponseVO;
import com.bizvane.content.feign.vo.material.MaterialPageRequestVO;
import com.bizvane.content.feign.vo.material.MaterialSaveRequestVO;
import com.bizvane.content.feign.vo.material.MaterialSaveResponseVO;
import com.bizvane.content.feign.vo.material.MaterialUpdateRequestVO;
import com.bizvane.content.feign.vo.material.MaterialUpdateResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MaterialServiceImpl
implements MaterialService {
    private final IContentMaterialService contentMaterialService;
    private final IContentMaterialLabelRelService contentMaterialLabelRelService;
    private final IContentMaterialLabelService contentMaterialLabelService;

    @Override
    public ResponseData<MaterialDetailResponseVO> selectMaterialDetail(MaterialDetailRequestVO requestVO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContentMaterialPO::getContentMaterialCode, (Object)requestVO.getContentMaterialCode())).eq(requestVO.getType() != null, ContentMaterialPO::getType, (Object)requestVO.getType())).last("limit 1");
        ContentMaterialPO materialPO = (ContentMaterialPO)this.contentMaterialService.getOne((Wrapper)queryWrapper);
        MaterialDetailResponseVO responseVO = ConvertUtil.po2vo(materialPO);
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<PageInfo<MaterialDetailResponseVO>> selectMaterialPage(MaterialPageRequestVO requestVO) {
        List contentMaterialLabelRelPOS;
        Page page = new Page((long)requestVO.getPageNum().intValue(), (long)requestVO.getPageSize().intValue());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContentMaterialPO::getType, (Object)requestVO.getType())).like(StringUtils.isNotBlank((CharSequence)requestVO.getMaterialName()), ContentMaterialPO::getTitle, (Object)requestVO.getMaterialName())).gt(requestVO.getModifiedDateStart() != null, ContentMaterialPO::getModifiedDate, (Object)requestVO.getModifiedDateStart())).lt(requestVO.getModifiedDateEnd() != null, ContentMaterialPO::getModifiedDate, (Object)requestVO.getModifiedDateEnd());
        if (StringUtils.isNotBlank((CharSequence)requestVO.getMaterialLabelCode()) && CollectionUtils.isNotEmpty((Collection)(contentMaterialLabelRelPOS = this.contentMaterialLabelRelService.listByLabelCode(requestVO.getMaterialLabelCode())))) {
            List materialCodeResult = contentMaterialLabelRelPOS.stream().map(ContentMaterialLabelRelPO::getContentMaterialCode).collect(Collectors.toList());
            queryWrapper.in(ContentMaterialPO::getContentMaterialCode, materialCodeResult);
        }
        Page materialPOPage = (Page)this.contentMaterialService.page((IPage)page, (Wrapper)queryWrapper);
        List resultList = materialPOPage.getRecords().stream().map(contentMaterialPO -> ConvertUtil.po2vo(contentMaterialPO)).collect(Collectors.toList());
        PageInfo pageResult = new IPageUtil(materialPOPage, resultList).getPageInfo();
        return ResponseUtil.success(pageResult);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData<MaterialSaveResponseVO> saveMaterial(MaterialSaveRequestVO requestVO) {
        ContentMaterialPO contentMaterialPO = new ContentMaterialPO();
        contentMaterialPO.setType(requestVO.getType());
        contentMaterialPO.setCoverImage(requestVO.getCoverImage());
        contentMaterialPO.setFileUrl(requestVO.getFileUrl());
        contentMaterialPO.setTitle(requestVO.getTitle());
        contentMaterialPO.setContent(requestVO.getContent());
        contentMaterialPO.setRemark(requestVO.getRemark());
        contentMaterialPO.setContentMaterialCode(UID.getUid());
        contentMaterialPO.setCreateUserCode(requestVO.getOptUserCode());
        contentMaterialPO.setCreateUserName(requestVO.getOptUserName());
        boolean result = this.contentMaterialService.save((Object)contentMaterialPO);
        this.batchSaveMaterialLabelRel(requestVO, contentMaterialPO.getContentMaterialCode());
        MaterialSaveResponseVO responseVO = new MaterialSaveResponseVO();
        responseVO.setContentMaterialCode(contentMaterialPO.getContentMaterialCode());
        responseVO.setOptStatus(result);
        return ResponseUtil.success((Object)result);
    }

    @Override
    public ResponseData<MaterialUpdateResponseVO> updateMaterial(MaterialUpdateRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(ContentMaterialPO::getCoverImage, (Object)requestVO.getCoverImage())).set(ContentMaterialPO::getFileUrl, (Object)requestVO.getFileUrl())).set(ContentMaterialPO::getTitle, (Object)requestVO.getTitle())).set(StringUtils.isNotBlank((CharSequence)requestVO.getContent()), ContentMaterialPO::getContent, (Object)requestVO.getContent())).set(StringUtils.isNotBlank((CharSequence)requestVO.getRemark()), ContentMaterialPO::getRemark, (Object)requestVO.getRemark())).set(ContentMaterialPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(ContentMaterialPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(ContentMaterialPO::getContentMaterialCode, (Object)requestVO.getMaterialCode());
        boolean result = this.contentMaterialService.update((Wrapper)updateWrapper);
        if (result) {
            this.contentMaterialLabelRelService.deleteByMaterialCode((OptUserVO)requestVO, requestVO.getMaterialCode());
            this.batchSaveMaterialLabelRel((MaterialSaveRequestVO)requestVO, requestVO.getMaterialCode());
        }
        MaterialUpdateResponseVO responseVO = new MaterialUpdateResponseVO();
        responseVO.setOptStatus(result);
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<MaterialDeleteResponseVO> deleteMaterial(MaterialDeleteRequestVO requestVO) {
        boolean result = this.contentMaterialService.deleteByCode((OptUserVO)requestVO, requestVO.getContentMaterialCode());
        MaterialDeleteResponseVO responseVO = new MaterialDeleteResponseVO();
        responseVO.setOptStatus(result);
        return ResponseUtil.success((Object)responseVO);
    }

    private void batchSaveMaterialLabelRel(MaterialSaveRequestVO materialSaveVO, String contentMaterialCode) {
        List materialLabelCodeList = materialSaveVO.getMaterialLabelCodeList();
        if (CollectionUtils.isEmpty((Collection)materialLabelCodeList)) {
            return;
        }
        List contentMaterialLabelPOS = this.contentMaterialLabelService.listByCodeList(materialLabelCodeList);
        if (CollectionUtils.isEmpty((Collection)contentMaterialLabelPOS)) {
            return;
        }
        List contentMaterialLabelRelPOList = contentMaterialLabelPOS.stream().map(contentMaterialLabelPO -> {
            ContentMaterialLabelRelPO contentMaterialLabelRelPO = new ContentMaterialLabelRelPO();
            contentMaterialLabelRelPO.setContentMaterialCode(contentMaterialCode);
            contentMaterialLabelRelPO.setContentMaterialLabelRelCode(UID.getUid());
            contentMaterialLabelRelPO.setContentMaterialLabelCode(contentMaterialLabelPO.getContentMaterialLabelCode());
            contentMaterialLabelRelPO.setCreateUserCode(materialSaveVO.getOptUserCode());
            contentMaterialLabelRelPO.setCreateUserName(materialSaveVO.getOptUserName());
            return contentMaterialLabelRelPO;
        }).collect(Collectors.toList());
        this.contentMaterialLabelRelService.saveBatch(contentMaterialLabelRelPOList);
    }

    public MaterialServiceImpl(IContentMaterialService contentMaterialService, IContentMaterialLabelRelService contentMaterialLabelRelService, IContentMaterialLabelService contentMaterialLabelService) {
        this.contentMaterialService = contentMaterialService;
        this.contentMaterialLabelRelService = contentMaterialLabelRelService;
        this.contentMaterialLabelService = contentMaterialLabelService;
    }
}

