/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.content.api.service.MaterialLabelService;
import com.bizvane.content.api.util.ConvertUtil;
import com.bizvane.content.api.util.IPageUtil;
import com.bizvane.content.domain.model.entity.ContentMaterialLabelPO;
import com.bizvane.content.domain.service.IContentMaterialLabelRelService;
import com.bizvane.content.domain.service.IContentMaterialLabelService;
import com.bizvane.content.domain.util.ResponseUtil;
import com.bizvane.content.feign.vo.OptUserVO;
import com.bizvane.content.feign.vo.material.MaterialLabelDeleteRequestVO;
import com.bizvane.content.feign.vo.material.MaterialLabelDeleteResponseVO;
import com.bizvane.content.feign.vo.material.MaterialLabelDetailRequestVO;
import com.bizvane.content.feign.vo.material.MaterialLabelDetailResponseVO;
import com.bizvane.content.feign.vo.material.MaterialLabelPageRequestVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class MaterialLabelServiceImpl
implements MaterialLabelService {
    private final IContentMaterialLabelService contentMaterialLabelService;
    private final IContentMaterialLabelRelService contentMaterialLabelRelService;

    @Override
    public ResponseData<MaterialLabelDetailResponseVO> selectMaterialLabelDetail(MaterialLabelDetailRequestVO requestVO) {
        ContentMaterialLabelPO contentMaterialLabelPO = this.contentMaterialLabelService.selectOneByCode(requestVO.getContentMaterialLabelCode());
        MaterialLabelDetailResponseVO materialLabelDetailResponseVO = ConvertUtil.po2vo(contentMaterialLabelPO);
        return ResponseUtil.success((Object)materialLabelDetailResponseVO);
    }

    @Override
    public ResponseData<PageInfo<MaterialLabelDetailResponseVO>> selectMaterialLabelPage(MaterialLabelPageRequestVO requestVO) {
        Page page = new Page((long)requestVO.getPageNum().intValue(), (long)requestVO.getPageSize().intValue());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Page materialLabelPOPage = (Page)this.contentMaterialLabelService.page((IPage)page, (Wrapper)queryWrapper);
        List resultList = materialLabelPOPage.getRecords().stream().map(contentMaterialLabelPO -> ConvertUtil.po2vo(contentMaterialLabelPO)).collect(Collectors.toList());
        PageInfo pageResult = new IPageUtil(materialLabelPOPage, resultList).getPageInfo();
        return ResponseUtil.success(pageResult);
    }

    @Override
    public ResponseData<MaterialLabelDeleteResponseVO> deleteMaterialLabel(MaterialLabelDeleteRequestVO requestVO) {
        String contentMaterialLabelCode = requestVO.getContentMaterialLabelCode();
        List contentMaterialLabelRelPOS = this.contentMaterialLabelRelService.listByLabelCode(contentMaterialLabelCode);
        if (CollectionUtils.isNotEmpty((Collection)contentMaterialLabelRelPOS)) {
            return ResponseUtil.fail((String)"\u5b58\u5728\u6709\u6548\u7d20\u6750\u5173\u8054\u6807\u7b7e,\u65e0\u6cd5\u5220\u9664\u7d20\u6750\u6807\u7b7e");
        }
        Boolean result = this.contentMaterialLabelService.deleteByCode((OptUserVO)requestVO, contentMaterialLabelCode);
        return ResponseUtil.success((Object)result);
    }

    public MaterialLabelServiceImpl(IContentMaterialLabelService contentMaterialLabelService, IContentMaterialLabelRelService contentMaterialLabelRelService) {
        this.contentMaterialLabelService = contentMaterialLabelService;
        this.contentMaterialLabelRelService = contentMaterialLabelRelService;
    }
}

