/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.content.api.service.FitmentService;
import com.bizvane.content.api.util.ConvertUtil;
import com.bizvane.content.api.util.IPageUtil;
import com.bizvane.content.domain.model.entity.AppletFitmentPO;
import com.bizvane.content.domain.service.impl.AppletFitmentServiceImpl;
import com.bizvane.content.domain.util.ResponseUtil;
import com.bizvane.content.domain.util.UID;
import com.bizvane.content.feign.vo.OptUserVO;
import com.bizvane.content.feign.vo.PageVO;
import com.bizvane.content.feign.vo.fitment.FitmentAddRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentAddResponseVO;
import com.bizvane.content.feign.vo.fitment.FitmentDeleteRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentDeleteResponseVO;
import com.bizvane.content.feign.vo.fitment.FitmentSelectDetailRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentSelectDetailResponseVO;
import com.bizvane.content.feign.vo.fitment.FitmentSelectPageRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentUpdateRequestVO;
import com.bizvane.content.feign.vo.fitment.FitmentUpdateResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FitmentServiceImpl
implements FitmentService {
    private final AppletFitmentServiceImpl appletFitmentService;

    @Override
    public ResponseData<FitmentSelectDetailResponseVO> selectDetail(FitmentSelectDetailRequestVO requestVO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(requestVO.getFitmentType() != null, AppletFitmentPO::getFitmentType, (Object)requestVO.getFitmentType())).eq(requestVO.getChannelType() != null, AppletFitmentPO::getChannelType, (Object)requestVO.getChannelType())).eq(AppletFitmentPO::getAppletFitmentCode, (Object)requestVO.getFitmentType())).last("limit 1");
        AppletFitmentPO appletFitmentPO = (AppletFitmentPO)this.appletFitmentService.getOne((Wrapper)queryWrapper);
        FitmentSelectDetailResponseVO fitmentSelectDetailResponseVO = ConvertUtil.po2vo(appletFitmentPO);
        return ResponseUtil.success((Object)fitmentSelectDetailResponseVO);
    }

    @Override
    public ResponseData<PageInfo<FitmentSelectDetailResponseVO>> selectPage(FitmentSelectPageRequestVO requestVO) {
        Page page = new Page();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AppletFitmentPO::getChannelType, (Object)requestVO.getChannelType())).eq(AppletFitmentPO::getFitmentType, (Object)requestVO.getFitmentType())).like(StringUtils.isNotBlank((CharSequence)requestVO.getHeaderName()), AppletFitmentPO::getHeaderName, (Object)requestVO.getHeaderName());
        Page fitmentPOPage = (Page)this.appletFitmentService.page((IPage)page, (Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)fitmentPOPage.getRecords())) {
            return new ResponseData(new IPageUtil((PageVO)requestVO).getPageInfo());
        }
        List resultList = fitmentPOPage.getRecords().stream().map(appletFitmentPO -> ConvertUtil.po2vo(appletFitmentPO)).collect(Collectors.toList());
        PageInfo pageResult = new IPageUtil(fitmentPOPage, resultList).getPageInfo();
        return ResponseUtil.success(pageResult);
    }

    @Override
    public ResponseData<FitmentAddResponseVO> addFitment(FitmentAddRequestVO requestVO) {
        AppletFitmentPO appletFitmentPO = new AppletFitmentPO();
        appletFitmentPO.setFitmentType(requestVO.getFitmentType());
        appletFitmentPO.setChannelType(requestVO.getChannelType());
        appletFitmentPO.setHeaderName(requestVO.getHeaderName());
        appletFitmentPO.setInfo(requestVO.getInfoJson());
        appletFitmentPO.setStatus(requestVO.getStatus());
        appletFitmentPO.setBgColor(requestVO.getBgColor());
        appletFitmentPO.setCreateUserName(requestVO.getOptUserName());
        appletFitmentPO.setCreateUserCode(requestVO.getOptUserCode());
        appletFitmentPO.setAppletFitmentCode(UID.getUid());
        Boolean result = this.appletFitmentService.save((Object)appletFitmentPO);
        FitmentAddResponseVO responseVO = new FitmentAddResponseVO();
        responseVO.setAppletFitmentCode(appletFitmentPO.getAppletFitmentCode());
        responseVO.setOptStatus(result.booleanValue());
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<FitmentUpdateResponseVO> updateFitment(FitmentUpdateRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(AppletFitmentPO::getBgColor, (Object)requestVO.getBgColor())).set(AppletFitmentPO::getHeaderName, (Object)requestVO.getHeaderName())).set(AppletFitmentPO::getInfo, (Object)requestVO.getInfoJson())).set(AppletFitmentPO::getStatus, (Object)requestVO.getStatus())).set(AppletFitmentPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(AppletFitmentPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(AppletFitmentPO::getAppletFitmentCode, (Object)requestVO.getAppletFitmentCode());
        Boolean result = this.appletFitmentService.update((Wrapper)updateWrapper);
        FitmentUpdateResponseVO responseVO = new FitmentUpdateResponseVO();
        responseVO.setAppletFitmentCode(responseVO.getAppletFitmentCode());
        responseVO.setOptStatus(result.booleanValue());
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<FitmentDeleteResponseVO> deleteFitment(FitmentDeleteRequestVO requestVO) {
        boolean result = this.appletFitmentService.deleteByCode((OptUserVO)requestVO, requestVO.getAppletFitmentCode());
        FitmentDeleteResponseVO responseVO = new FitmentDeleteResponseVO();
        responseVO.setOptStatus(result);
        return ResponseUtil.success((Object)responseVO);
    }

    public FitmentServiceImpl(AppletFitmentServiceImpl appletFitmentService) {
        this.appletFitmentService = appletFitmentService;
    }
}

