/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.bizvane.content.api.model.dto.oss.ExcelExportDataDTO;
import com.bizvane.content.api.service.ExcelToObjectService;
import com.bizvane.content.api.service.OSSClientService;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExcelToObjectServiceImpl
implements ExcelToObjectService {
    private static final Logger log = LoggerFactory.getLogger(ExcelToObjectServiceImpl.class);
    private final OSSClientService ossClientService;

    @Override
    public ExcelExportDataDTO readExcelToObject(String key, final int size, int page) {
        URL u;
        String url = this.ossClientService.generateDownloadPresignedUrl(key, 600L, null);
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            log.error("new url error,url={}", (Object)url, (Object)e);
            throw new RuntimeException(e);
        }
        int skip = (page - 1) * size;
        final ArrayList list = new ArrayList(size);
        final ExcelExportDataDTO result = new ExcelExportDataDTO();
        try (InputStream is = u.openStream();){
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)is, (ReadListener)new ReadListener<LinkedHashMap<Integer, String>>(){
                int count = 0;
                boolean hasNext = false;

                public void invoke(LinkedHashMap<Integer, String> data, AnalysisContext context) {
                    ++this.count;
                    if (this.count > size) {
                        this.hasNext = true;
                        return;
                    }
                    list.add(new ArrayList<String>(data.values()));
                }

                public void doAfterAllAnalysed(AnalysisContext context) {
                    result.setList(list);
                    result.setHasNext(this.hasNext);
                }
            }).sheet().headRowNumber(Integer.valueOf(skip))).doRead();
        }
        catch (IOException e) {
            log.error("read excel error,url={}", (Object)url, (Object)e);
            throw new RuntimeException(e);
        }
        return result;
    }

    public ExcelToObjectServiceImpl(OSSClientService ossClientService) {
        this.ossClientService = ossClientService;
    }
}

