/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.content.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.content.api.model.dto.oss.TempCredentialDTO;
import com.bizvane.content.api.service.UploadService;
import com.bizvane.content.domain.enums.FileTypeEnum;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class BuinessCacheComponent {
    private final StringRedisTemplate stringRedisTemplate;
    private final UploadService uploadService;

    public TempCredentialDTO getTempCredential(FileTypeEnum fileTypeEnum) {
        String key = "qcloud:tempCredential:".concat(fileTypeEnum.getType().toString());
        long expireSeconds = 1680L;
        if (!this.stringRedisTemplate.hasKey((Object)key).booleanValue() && expireSeconds > 0L) {
            TempCredentialDTO tempCredential = this.uploadService.getTempCredential(fileTypeEnum);
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSON.toJSONString((Object)tempCredential), expireSeconds, TimeUnit.SECONDS);
            return tempCredential;
        }
        String tempCredentialString = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        TempCredentialDTO tempCredential = (TempCredentialDTO)JSON.parseObject((String)tempCredentialString, TempCredentialDTO.class);
        long epochSecondNow = LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().getEpochSecond();
        if (tempCredential.getStartTime() + expireSeconds < epochSecondNow) {
            this.stringRedisTemplate.delete((Object)key);
        }
        return tempCredential;
    }

    public BuinessCacheComponent(StringRedisTemplate stringRedisTemplate, UploadService uploadService) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.uploadService = uploadService;
    }
}

