package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
/**
 * @author admin
 * @date
 */
@Data
public class AddCouponDefToErpRequestVO extends BaseModel {

    /**
     * 有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天
     * */
    private Byte validType;
    /**
     * true在时间段内，false不在时间段内
     * */
    private boolean  validTimeState;
    /**
     * 有效期开始时间
     * */
    private Date validDateStart;
    /**
     * 有效期结束时间
     * */
    private Date validDateEnd;
    /**
     * 渠道限制（1仅线下，2全渠道，3仅线上，4员工券，5天猫券）
     * */
    private Byte useChannel;
    /**
     * 转增后1核销送券，0不送券
     * */
    private Boolean transferSend;
    /**
     * 可裂变1，不可以0
     * */
    private Boolean transferFission;
    /**
     * 能否叠加会员卡使用（0-不能，1-能）
     * */
    private Boolean superpositionMemberCard;
    /**
     * storeWhitelist
     * */
    private String storeWhitelist;
    /**
     * offlinePrdCode
     * */
    private String offlinePrdCode;
    /**
     * 是否允许转赠（1允许转赠，0不允许转赠
     * */
    private Boolean isTransfer;
    /**
     * 是否允许叠加（1是，0否）
     * */
    private Boolean isSuperposition;
    /**
     * 券定义类型：1-线上定义，2-erp生成
     * */
    private Byte couponDefinitionType;
    /**
     * 自定义券背景图
     * */
    private String couponBackGroundUrl;

    /**
     * 劵背景设置（1 系统默认 0 自定义背景图）
     * */
    private int couponBackGroundType;

    /**
     * 商品白名单（复合）
     * */
    private String commodityCompoundWhitelist;

    /**
     * 领取后几天有效
     */
    private Integer validDay;

    /**
     * 商品黑名单
     */
    private String commodityBlacklist;
    /**
     * 是否允许退单退券(1退单退券,0退单不退券)
     * */
    private Byte chargeBack;

    /**
     * 适用门店类型：1-全部适用，2-部分适用
     * */
    private Byte applianceStoreType;

    /**
     * 适用运营组织类型：1-全部适用，2-部分适用
     * */
    private Integer applianceOrgType;

    /**
     * 适用运营组织codes
     * */
    private String applianceOrgCodes;

    /**
     * 活动叠加条件：1-不允许叠加其他活动使用，2-允许叠加其他活动使用，3-允许部分活动使用
     * */
    private Byte activitySuperpositionType;

    /**
     * 适用商品类型：1-全部适用，2-部分适用, 3-商品属性
     * */
    private Byte applianceCommodityType;

    /**
     * 描述
     * */

    private String info;

    /*
    *券的面额
    * */
    private BigDecimal money;

    /**
     * 卷类型号
     * */
    private String erpCouponDefinitionCode;

    /**
     * 卷类型ID
     * */
    private Integer erpCouponDefinitionId;

    /**
     * 卷名称
     * */
    private String couponName;

    /**
     * 券类型 现金券=1、折扣券=2
     * */
    private Integer preferentialType;

    /**
     * 折扣购买限制 低于X折不能使用
     * */
    private BigDecimal minDiscount;

    /**
     * 折扣
     * */
    private BigDecimal discount;

    /**
     * 券定义创建时间
     * */
    private String createDate;

    /**
     * 订单满条件 有满减金额1 没有0
     * */
    private Integer minConsumeFlag;

    /**
     * 订单满金额
     * */
    private BigDecimal minConsume;

    /**
     * 最高优惠金额
     */
    private BigDecimal maxPreferential;

    /**
     * 商品单一白名单
     */
    private String commodityWhitelist;
}
