package com.bizvane.connectorservice.entity.common;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author liuying
 * @date 2018/8/14
 * @description
 */

public class OrderItemRequestVO implements Serializable {

    /**
     * 数量
     */
    private Integer count;

    /**
     * 市场价
     */
    private BigDecimal price;

    /**
     * 规格(商品样式)
     */
    private String specification;

    /**
     * 商品编号
     */
    private String code;

    /**
     * 标准价(吊牌价)
     */
    private BigDecimal standardPrice;

    /**
     * 标准金额 = 标准价 * 数量
     */
    private BigDecimal standardAmount;

    /**
     * 销售价 = 应收金额 * 数量
     */
    private BigDecimal marketValue;

    /**
     * 应收金额=市场价*数量
     */
    private BigDecimal amountReceivable;

    /**
     * 成交价=实际支付金额
     */
    private BigDecimal transactionAmount;

    /**
     * 商品skucode
     */
    private String skuCode;

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getStandardPrice() {
        return standardPrice;
    }

    public void setStandardPrice(BigDecimal standardPrice) {
        this.standardPrice = standardPrice;
    }

    public BigDecimal getStandardAmount() {
        return standardAmount;
    }

    public void setStandardAmount(BigDecimal standardAmount) {
        this.standardAmount = standardAmount;
    }

    public BigDecimal getMarketValue() {
        return marketValue;
    }

    public void setMarketValue(BigDecimal marketValue) {
        this.marketValue = marketValue;
    }

    public BigDecimal getAmountReceivable() {
        return amountReceivable;
    }

    public void setAmountReceivable(BigDecimal amountReceivable) {
        this.amountReceivable = amountReceivable;
    }

    public BigDecimal getTransactionAmount() {
        return transactionAmount;
    }

    public void setTransactionAmount(BigDecimal transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    /**
     * 线上产品名称
     * 线上产品名称不能为空
     */
    private String onlineProductName;

    public String getOnlineProductName() {
        return onlineProductName;
    }

    public void setOnlineProductName(String onlineProductName) {
        this.onlineProductName = onlineProductName;
    }
}
