package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * @Author liramon
 * @Date 2020/11/12 10:25
 * @Description
 * @Version 1.0
 */
@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/wm361")
public interface WmConnectorServiceFeign {

    /**
     * 根据id获取token
     * @param brandId
     * @return
     */
    @RequestMapping(value ="queryWmToken", method = RequestMethod.POST)
    Result queryWmToken(@RequestParam("brandId") Long brandId);


    /**
     * 获取会员wid
     * @param brandId
     * @param cardNo
     * @return long
     */
    @RequestMapping(value ="getMemberWid", method = RequestMethod.POST)
    Long getMemberWid(@RequestParam("brandId") Long brandId, @RequestParam("cardNo") String cardNo);

    /**
     * 根据品牌id获取总店id
     * @param brandId
     * @return long
     * */
    @RequestMapping(value ="getMainStoreId", method = RequestMethod.POST)
    Long getMainStoreId(@RequestParam("brandId") Long brandId);

}
