package com.bizvane.connectorservice.entity.param;

import lombok.Data;

@Data
public class MemberOrderBaseInfoParam {

    private String orderNo;

    //外部订单号/⼩票编号(唯⼀不可重复)
    private String outOrderNo;

    //关联的外部原订单/⼩票编号(唯⼀不可重复)，换货订单必填
    private String outOriginalOrderNo;

    //订单类型：1-普通订单；99-充值订单（暂不⽀持）
    private Integer orderType;

    //订单状态： 8-已完成
    private Integer status;

    //⽀付类型：1-线上⽀付；2-线下⽀付（含货到付款）
    private Integer paymentType;

    //  订单渠道：0-公众号；1-⼩程序；2-H5；3-QQ；4-微博；5-字节跳动⼩程序；
    //  6-⽀付宝⼩程序；7-PC后台；8-安卓app；9-苹果app；10-百度⼩程序；11-PAD；
    //  12-⾃有APP；15-⼤屏扫码；16-企业微信；18-芸智免密；101-分销商；201-淘宝；
    //  202-天猫；203-京东；204-拼多多；205-苏宁易购；206-有赞；207-抖⾳；208-快⼿；
    //  209-美团；210-惠聚；251-pos；252-OMS；253-ERP；260-友搭；262-直播；264-微商城；265-⾃有渠道；280-cps导⼊订单
    private Integer channelType;

    //下单时间
    private String orderTime;

    //付完成时的时间
    private String finishPaymentTime;

    //更新时间
    private String updateTime;

    //是否被删除1.是 2.否
    private Integer delete;

    // 售卖渠道类型：10001-线上⽹店；10002-线下⻔店（默认）。
    private Integer saleChannelType;

    //订单业务来源：1-普通订单；10-换货订单（⽀持订单和商品⾦额及购买件数为负，⾦额和件数为负商品处理为售后项）
    private Integer bizSourceType;

    //订单⽀付状态： 2-已⽀付
    private Integer payStatus;

    // 订单完成时间，时间戳
    private Integer finishTime;

    //订单备注
    private String remark;

    //订单来源平台： 0-微盟、1-道讯、2-伯俊、3-达摩、4、百胜、5海鼎
    private Integer platformType;

}
