package com.bizvane.connectorservice.entity.param;


import lombok.Data;

/**
 * 会员绑定渠道
 */
@Data
public class MemberBindChannelParam {


    /**
     * 会员手机号（必填）
     */
    private String phone;

    /**
     * 渠道来源类型：0-微信公众号；1-微信小程序；2-微信unionid；4-手机号。（必填）
     */
    private Integer source;

    /**
     * 应用 appid，例如公众号 appid 或小程序 appid。如果是手机号或 unionid，则传入 default。（必填）
     */
    private String appId;

    /**
     * 渠道内的关联字段，比如微信是 openid，手机号渠道对应手机号,( 必填)
     */
    private String originalId;

    /**
     * 用户wid
     */
    private Long wid;
}
