package com.bizvane.connectorservice.interfaces.weimeng;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.param.*;
import com.bizvane.connectorservice.entity.po.MbrMembersPo;
import com.bizvane.connectorservice.entity.vo.wm.WmMemberBaseInfoDto;
import java.util.List;

/**
 * 微盟对接CRM ，会员wid转换
 */
public interface SysWeimengService {

    /**
     * 会员新增接口
     * @param
     * @return Result
     * 2022-12-1 14:08:23
     */
    Result<Object> addMemberInfoTowm(List<MemberInfoModelParam> memberInfoModelParams);

    /**
     * 更新会员等级信息接口
     * @param memberInfoModelParam
     * @return Result
     * 2022-12-1 14:46:48
     */
    Result<Object> updateMemberLevelTowm(MemberInfoModelParam memberInfoModelParam);

    /**
     * 更新会员信息接口
     * @param memberInfoModelParam
     * @return Result
     * 2022-12-1 14:46:48
     */
    Result<Object> updateMemberInfoTowm(MemberInfoModelParam memberInfoModelParam);

    /**
     * 更新会员服务门店和导购信息接口
     * @param memberInfoModelParam
     * @return Result
     * 2022-12-1 14:46:48
     */
    Result<Object> updateMemberServiceTowm(MemberInfoModelParam memberInfoModelParam);

    /**
     * 根据手机号获取微盟wid
     * @return
     */
    Long findWeimengWidByPhone(String phone);

    /**
     * 根据CRM memberCode 查询微盟wid
     * @return
     */
    Long findWeimengWidBySysMemberCode(String memberCode);

    /**
     * 查询会员信息
     * @param keyword
     * @param type
     * @param brandCode
     * @return
     */
    MbrMembersPo findMbrMemberBy(String keyword, int type, String brandCode);

    /**
     * 根据手机号查找微盟会员基本信息
     * @return
     */
    WmMemberBaseInfoDto findWmMemberBaseInfoByPhone(String phone);

    /**
     * 同步会员标签新增
     * @anthor shifeng
     * @version 1.0.1
     * 2022-12-1 11:44:08
     */
    Result<Object> addNewMemberLabelTowm(List<MemberLabelInfoParam> memberLabelInfoParams);

    /**
     * 同步会员标签新增
     * @anthor shifeng
     * @version 1.0.1
     * 2022-12-1 11:44:08
     */
    Result<Object> memberLabelAttrParam(List<MemberLabelAttrParam> memberLabelAttrParams);

    /**
     * 同步会员标签新增
     * @anthor shifeng
     * @param  memberInfoModelParams
     * @version 1.0.1
     * 2022-12-1 11:44:08
     */
    Result<Object> memberAddLabelBind(List<MemberInfoModelParam> memberInfoModelParams);

    /**
     * 同步会员标签新增
     * @anthor shifeng
     * @param  memberInfoModelParam
     * @return Result
     * @version 1.0.1
     * 2022-12-1 11:44:08
     */
    Result<Object> memberRemoveLabelBind(MemberInfoModelParam memberInfoModelParam);

    /**
     * 优惠券定义同步
     * @param param
     * @return
     */
    Result<Object> couponDefineTowm(CouponDefinitionParam param);

    /**
     * 优惠券作废
     * @param param
     * @return
     */
    Result<Object> unuseCouponTowm(CouponCancelParam param);

    /**
     * 优惠券使用
     * @param param
     * @return
     */
    Result<Object> useCouponEntityTowm(CouponUseParam param);

    /**
     * 会员领劵
     * @param param
     * @return
     */
    Result<Object> couponBindMember(CouponBindMemberParam param);

    /**
     * 会员订单积分同步
     * @anthor shifeng
     * @return Result
     * 2022-12-2 14:56:44
     */
    Result<Object> memberOrderTowm(CrmMemberOrderParam crmMemberOrderParam);

    /**
     * 会员订单积分同步
     * @anthor shifeng
     * @return Result
     * 2022-12-2 14:56:44
     */
    Result<Object> memberOrderCancelTowm(CrmMemberOrderParam crmMemberOrderParam);

    /**
     * 会员订单积分同步
     * @anthor shifeng
     * @return Result
     * 2022-12-2 14:56:44
     */
    Result<Object> memberOrderUpdateBiz(CrmMemberOrderUpdateParam crmMemberOrderUpdateParam);

    /**
     * 微盟创建商品信息同步
     * @param param
     * @return
     */
    Result<Object> syncWmCreateGoodsMsg(WmSyncGoodsCreateParam param);


    /**
     * 会员绑定渠道推送微盟
     * @param params
     * @return
     */
    Result<Object> memberBindChannel(List<MemberBindChannelParam> params);
}
