package com.bizvane.connectorservice.entity.param;

import lombok.Data;

@Data
public class RightsOrderParam {

    //售后类型 1
    private Integer rightsType;

    /**
     * 售后单来源渠道
     * 0 :公众号
     * 1 :⼩程序
     * 2 :H5
     * 3 :QQ
     * 4 :微博
     * 5 :字节跳动⼩程序
     * 1 售后单openapi
     * 售后单openapi
     * 1.1 导⼊售后单
     * 基础信息
     * 路径: /weimob_crm/v2.0/rights/import
     * 请求⽅法: POST
     * 请求参数
     * Headers:
     * Body:
     *   |─channelType integer 是
     * 6 :⽀付宝⼩程序
     * 7 :PC后台
     * 8 :安卓app
     * 9 :苹果app
     * 10 :百度智能⼩程序
     * 11 :PAD
     * 12 :⾃有APP
     * 15 :⼤屏扫码
     * 16 :企业微信
     * 18 :芸智免密
     * 101 :分销商
     * 201 :淘宝
     * 202 :天猫
     * 203 :京东
     * 204 :拼多多
     * 205 :苏宁易购
     * 206 :有赞
     * 207 :抖⾳
     * 208 :快⼿
     * 209 :美团
     * 210 :惠聚
     * 251 :POS
     * 252 :OMS
     * 253 :ERP
     * 260 :有搭
     * 261 :BOX
     * 262 :直播
     * 263 :积分商城
     * 264 :微商城
     * 265 :商家⾃有渠道
     * 280 :CPS导⼊订单
     */
    private Integer channelType;

    //售后单状态 已退款
    private Integer rightsStatus;

    /**
     * 售后触发起源
     * 1 :买家申请售后
     * 2 :商家取消订单
     */
    private Integer rightsCauseType;

    /**
     * 退款类型
     * 1 :线上退款
     * 2 :线下退款
     * 99 :⽆需退款
     */
    private Integer refundType;

    //外部售后单号
    private String outRightsNo;

    //售后备注
    private String remark;

    //商家⾃定义售后原因
    private String reason;

    //创建时间
    private Long createTime;

    //完成时间
    private Long finishTime;

    //同意时间
    private Long agreeTime;

    /**
     * 来源平台
     * 0 :微盟 微盟
     * 1 :道讯 道讯
     * 3 :达摩 达摩
     * 4 :百胜 百胜
     * 5 :海鼎 海鼎
     */
    private Integer platformType;

    /**
     * 退款⽅式
     * 1 :原路退回
     * 2 :⾮原路退回
     * 99 :⽆需退款
     */
    private Integer refundMethod;

}
