package com.bizvane.connectorservice.entity.req.wm;

import com.bizvane.connectorservice.entity.param.CouponUseParam;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * CRM -> WM
 * 核销优惠卷 入参
 */
@Data
public class CouponConsumeReq {

    /**
     * 订单总金额，单位：元。
     * 是否必填：是
     */
    private BigDecimal orderAmount;

    /**
     * 核销操作人 wid
     * 是否必填：是
     */
    private Long operator;

    /**
     * 核销方式：1- 线上核销 ；2- 线下核销。
     * 是否必填：是
     */
    private Integer useResourceType;

    /**
     * 核销场景：1-网店订单；7-api核销。
     * 是否必填：是
     */
    private Integer useScene;

    /**
     * 用户 wid
     * 是否必填：是
     */
    private Long wid;

    /**
     * 组织架构节点类型。类型包括：1-集团；2-品牌；3-区域；4部门；5-商场；6-楼层；10-门店；11-网点；100-自提点。
     * 是否必填：是
     */
    private Integer vidType;

    /**
     * 组织架构节点ID。可以通过B端页面店铺/店铺设置/组织架构找到该ID。
     * 是否必填：是
     */
    private Long vid;

    /**
     * 优惠券列表
     */
    private List<CouponOperate> operateCoupons;

    /**
     * 封装优惠券列表
     * @param param
     */
    public void buildCouponUseParam(CouponUseParam param){
        // 实际优惠金额，单位：元。 固定值 0
        BigDecimal amount = new BigDecimal("0");
        this.operateCoupons = new ArrayList<>();
        param.getOperateCoupons().forEach(coupon -> {
            CouponOperate couponOperate = new CouponOperate();
            couponOperate.setCouponTemplateId(coupon.getCouponTemplateId());
            couponOperate.setAmount(amount);
            couponOperate.setCode(coupon.getCode());
            this.operateCoupons.add(couponOperate);
        });

    }

    // ================  二级子类  ================
    /**
     * 优惠卷信息
     */
    @Data
    public static class CouponOperate{

        /**
         * 优惠券 ID。对应商户后台券列表优惠券 ID。可通过 weimob_crm/coupon/template/search 接口获取。
         * 是否必填：是
         */
        private Long couponTemplateId;

        /**
         * 订单号。售后作废必填。
         * 是否必填：否
         */
        private String orderNo;

        /**
         * 优惠券码值
         * 是否必填：是
         */
        private String code;

        /**
         * 实际优惠金额，单位：元。
         * 是否必填：是
         */
        private BigDecimal amount;
    }
}
