package com.bizvane.connectorservice.entity.param;


import lombok.Data;

/**
 * 微盟同步创建商品时的入参
 */
@Data
public class WmSyncGoodsCreateParam {


    /**
     * 消息的唯一标识
     */
    private String id;

    /**
     * 消息主题名称
     */
    private String topic;

    /**
     * 消息事件名称
     */
    private String event;

    /**
     *用户 ID
     */
    private String wid;

    /**
     * 商业操作系统 ID
     */
    private Long bosId;

    /**
     *签名
     */
    private String sign;

    /**
     * 消息内容
     */
    private WmGoods msgBody;


    @Data
    public static class WmGoods{

        /**
         * 组织架构节点 ID。组织的唯一标识，是创建组织时自动生成的 ID，可以通过 bos/organization/getList 接口获取该 ID。
         */
        private String vid;

        /**
         * 创建成功的商品 ID
         */
        private String goodsId;
    }
}
