package com.bizvane.connectorservice.constant;


/**
 * 微盟系统常量类
 */
public class WmSystemConstant {

    /**
     * 微盟接口返回成功code
     */
    public static final String SUCCESS_CODE = "0";

    /**
     * 微盟接口参数，操作人必填默认为 0
     */
    public static final Long WM_STSTEM_OPERATOR_ID = 0L;
    /**
     * 连接符号
     */
    public static final String LINK_AND = "&";

    /**
     * 链接符号
     */
    public static final String LINK_EQUAL = "=";

    /**
     * 链接符号
     */
    public static final String LINK_QUESTION = "?";

    /**
     * 微盟返回成功状态值
     */
    public static final String WM_RESULT_SUCCESS_STATUS = "0";


    /**
     * 调用微盟系统token 名称
     */
    public static final String WM_SYSTEM_CALL_TOKEN = "accesstoken";

    /**
     * 微盟系统reids 存储token的前缀
     */
    public static final String WM_SYSTEM_TOKEN_REDIS_KEY = "wm_system_token_redis_key";

    /**
     * 微盟系统reids 存储token的默认有效期（秒）
     * 获取token的默认有效期为7200秒，所以默认有效期减少5秒
     */
    public static final Long DEFAULT_WM_SYSTEM_TOKEN_REDIS_TIMEOUT = 3600L;

    /**
     * CRM -> 微盟系统的接口
     */
    /**
     * 获取微盟系统token接口
     */
    public static final String GET_WM_SYSTEM_TOKEN_INTERFACE = "/fuwu/b/oauth2/token";

    /**
     * 获取微盟系统会员基础信息的接口
     */
    public static final String GET_WM_MEMBER_BASE_INFO = "/apigw/bos/v2.0/user/superwid/get";

    /**
     * 修改会员等级时通知微盟
     */
    public static final String UPDATE_MEMBER_LEVEL = "/apigw/weimob_crm/v2.0/membercard/update";

    /**
     * 第一步
     * 创建优惠卷基础模板
     */
    public static final String CREATE_COUPON_BASIC_TEMPLATE = "/apigw/weimob_crm/v2.0/coupon/template/basic/create";

    /**
     * 第二步
     * 创建优惠卷模板
     */
    public static final String CREATE_COUPON_TEMPLATE = "/apigw/weimob_crm/v2.0/coupon/template/create";

    /**
     * 会员领卷
     */
    public static final String MEMBER_GET_COUPON = "/apigw/weimob_crm/v2.0/coupon/customer/sync";

    /**
     * 卷作废
     */
    public static final String COUPON_CANCEL = "/apigw/weimob_crm/v2.0/coupon/cancel";

    /**
     * 核销优惠券
     */
    public static final String COUPON_USE = "/apigw/weimob_crm/v2.0/coupon/consume";


    /**
     * 会员标签新增操作
     */
    public static final String MEMBER_LABEL_INSERT = "/apigw/weimob_cdp/v2.0/tag/insertList";

    /**
     * 会员标签属性新增操作
     */
    public static final String MEMBER_LABEL_ATTR_INSERT = "/apigw/weimob_cdp/v2.0/tag/attribute/create";

    /**
     * 会员新增操作
     */
    public static final String MEMBER_INSERT = "/apigw/weimob_crm/v2.0/customer/import";

    /**
     * 会员修改操作
     */
    public static final String MEMBER_UPDATE = "/apigw/weimob_crm/v2.0/customer/update";

    /**
     * 会员修改操作 - 导购
     */
    public static final String MEMBER_STAFF_UPDATE = "/apigw/weimob_guide/v2.0/customer/guider/changeBind";

    /**
     * 会员修改操作 - 门店
     */
    public static final String MEMBER_STORE_UPDATE = "/apigw/weimob_crm/v2.0/customer/organization/bind";

    /**
     * 会员wid查询
     */
    public static final String MEMBER_WID = "/apigw/bos/v2.0/user/superwid/get";

    /**
     * 会员wid查询
     */
    public static final String MEMBER_LEVEL = "/apigw/weimob_crm/v2.0/membercard/level/privilege/getList";

    /**
     * 会员wid查询
     */
    public static final String GUIDER_WID = "/apigw/weimob_guide/v2.0/guider/get";

    /**
     * 会员贴标签操作
     */
    public static final String MEMBER_ADD_LABEL = "/apigw/weimob_cdp/v2.0/customer/tag/bind";

    /**
     * 会员撕标签操作
     */
    public static final String MEMBER_REMOVE_LABEL = "/apigw/weimob_cdp/v2.0/customer/tag/unbind";

    /**
     * 同步订单信息
     */
    public static final String IMPORT_ORDER = "/apigw/weimob_crm/v2.0/order/import";

    /**
     * 同步订单信息
     */
    public static final String IMPORT_CANCEL_ORDER = "/apigw/weimob_crm/v2.0/rights/import";

    /**
     * 组织架构查询
     */
    public static final String ORG_QUERY_WID = "/apigw/bos/v2.0/organization/getList";

    /**
     * 组织架构查询
     */
    public static final String ORG_DETAIL_QUERY_WID = "/apigw/bos/v2.0/organization/detail/get";

    /**
     * 分页区域查询
     */
    public static final String REGION_PAGE_SEARCH = "/apigw/bos/v2.0/organization/getList";

    /**
     * 根据区域code查询区域
     */
    public static final String REGION_SEARCH_BY_CODE = "/apigw/bos/v2.0/organization/detail/get";

    /**
     * 分页查询商品
     */
    public static final String GOODS_PAGE_SEARCH = "/apigw/weimob_shop/v2.0/goods/getList";

    /**
     * 根据商品ID列表查询商品信息
     */
    public static final String FIND_GOODS_BY_ID = "/apigw/weimob_shop/v2.0/goods/getListById";


    /**
     * 会员绑定渠道
     */
    public static final String member_bind_channel = "/apigw/bos/v2.0/user/channel/bind";
}
