/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.connectorservice.entity.req.wm;

import com.bizvane.connectorservice.constant.WmSystemConstant;
import com.bizvane.connectorservice.entity.param.CouponDefinitionParam;
import com.bizvane.connectorservice.entity.param.CouponTemplateBaseInfo;
import com.bizvane.connectorservice.entity.param.CouponTemplateCreateInfo;
import com.bizvane.connectorservice.entity.param.CouponTemplateOtherSetting;
import com.bizvane.connectorservice.entity.param.CouponTemplateReduceRule;
import com.bizvane.connectorservice.entity.param.CouponTemplateSendRule;
import com.bizvane.connectorservice.entity.param.CouponTemplateUseRule;

public class CouponTemplateReq {
    private Integer vid;
    private Integer vidType;
    private CouponTemplateBaseInfo baseInfo;
    private CouponTemplateReduceRule reduceRule;
    private CouponTemplateSendRule sendRule;
    private CouponTemplateUseRule useRule;
    private CouponTemplateOtherSetting otherSetting;
    private CouponTemplateCreateInfo createInfo;

    public void buildCouponTemplateBaseInfo(CouponDefinitionParam param) {
        this.baseInfo = new CouponTemplateBaseInfo();
        int platformType = 1;
        this.baseInfo = new CouponTemplateBaseInfo();
        this.baseInfo.setCouponType(param.getPreferentialType().intValue());
        this.baseInfo.setPlatformType(platformType);
        this.baseInfo.setCouponSubType(this.packingCouponSubType(param.getUseChannel().byteValue()));
        this.baseInfo.setName(param.getCouponName());
        this.baseInfo.setBelongVid(param.getBelongVid());
    }

    public void buildCouponTemplateReduceRule(CouponDefinitionParam param) {
        int pricingType = 2;
        int couponCostType = 1;
        int couponCost = 0;
        this.reduceRule = new CouponTemplateReduceRule();
        this.reduceRule.setPricingType(pricingType);
        this.reduceRule.setCouponCostType(couponCostType);
        this.reduceRule.setCouponCost(couponCost);
        if (param.getPreferentialType() == 1) {
            int reducePriceType = 2;
            this.reduceRule.setReducePriceType(reducePriceType);
            this.reduceRule.setCashTicketAmt(param.getMoney());
        } else if (param.getPreferentialType() == 2) {
            int discountLimitType = 3;
            this.reduceRule.setDiscount(param.getDiscount().doubleValue());
            this.reduceRule.setDiscountLimitType(discountLimitType);
            this.reduceRule.setDiscountLimitValue(param.getMaxPreferential().toString());
        }
    }

    public void buildCouponTemplateSendRule(CouponDefinitionParam param) {
        int sendTimeType = 1;
        boolean isPayment = false;
        boolean customerDirectReceive = true;
        boolean merchantPublish = true;
        boolean activityPublish = true;
        boolean wechatLiveIssue = true;
        boolean enterpriseAssistant = true;
        this.sendRule = new CouponTemplateSendRule();
        this.sendRule.setSendTimeType(sendTimeType);
        this.sendRule.setIsPayment(isPayment);
        this.sendRule.setCustomerDirectReceive(customerDirectReceive);
        this.sendRule.setMerchantPublish(merchantPublish);
        this.sendRule.setActivityPublish(activityPublish);
        this.sendRule.setWechatLiveIssue(wechatLiveIssue);
        this.sendRule.setEnterpriseAssistant(enterpriseAssistant);
    }

    public void buildCouponTemplateUseRule(CouponDefinitionParam param) {
        boolean hasUseThreshold = true;
        boolean canCashTicket = true;
        boolean isAllTimeUse = true;
        boolean isAllUseScene = true;
        boolean canGoodsNumber = false;
        this.useRule = new CouponTemplateUseRule();
        this.useRule.setHasUseThreshold(hasUseThreshold);
        this.useRule.setCanCashTicket(canCashTicket);
        this.useRule.setGoodsCashTicket(param.getMinConsume().intValue());
        this.useRule.buildUseRoleSuperpositionRule(param);
        this.useRule.setIsAllTimeUse(isAllTimeUse);
        this.useRule.buildUseRoleCanUseDiscount(param);
        this.useRule.setIsAllUseScene(isAllUseScene);
        this.useRule.buildCouponTemplateAllScene(param);
        this.useRule.buildUseAcceptTypeDTO(param);
        this.useRule.setCanGoodsNumber(canGoodsNumber);
    }

    public void buildCouponTemplateOtherSetting(CouponDefinitionParam param) {
        boolean hasMemberTag = false;
        this.otherSetting = new CouponTemplateOtherSetting();
        this.otherSetting.setExplain(param.getInfo());
        this.otherSetting.setHasMemberTag(hasMemberTag);
    }

    public void buildCouponTemplateCreateInfo(CouponDefinitionParam param) {
        this.createInfo = new CouponTemplateCreateInfo();
        this.createInfo.setOperatorId(WmSystemConstant.WM_STSTEM_OPERATOR_ID);
    }

    private int packingCouponSubType(int useChannel) {
        if (useChannel == 1) {
            return 12;
        }
        return 11;
    }

    public Integer getVid() {
        return this.vid;
    }

    public Integer getVidType() {
        return this.vidType;
    }

    public CouponTemplateBaseInfo getBaseInfo() {
        return this.baseInfo;
    }

    public CouponTemplateReduceRule getReduceRule() {
        return this.reduceRule;
    }

    public CouponTemplateSendRule getSendRule() {
        return this.sendRule;
    }

    public CouponTemplateUseRule getUseRule() {
        return this.useRule;
    }

    public CouponTemplateOtherSetting getOtherSetting() {
        return this.otherSetting;
    }

    public CouponTemplateCreateInfo getCreateInfo() {
        return this.createInfo;
    }

    public void setVid(Integer vid) {
        this.vid = vid;
    }

    public void setVidType(Integer vidType) {
        this.vidType = vidType;
    }

    public void setBaseInfo(CouponTemplateBaseInfo baseInfo) {
        this.baseInfo = baseInfo;
    }

    public void setReduceRule(CouponTemplateReduceRule reduceRule) {
        this.reduceRule = reduceRule;
    }

    public void setSendRule(CouponTemplateSendRule sendRule) {
        this.sendRule = sendRule;
    }

    public void setUseRule(CouponTemplateUseRule useRule) {
        this.useRule = useRule;
    }

    public void setOtherSetting(CouponTemplateOtherSetting otherSetting) {
        this.otherSetting = otherSetting;
    }

    public void setCreateInfo(CouponTemplateCreateInfo createInfo) {
        this.createInfo = createInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CouponTemplateReq)) {
            return false;
        }
        CouponTemplateReq other = (CouponTemplateReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$vid = this.getVid();
        Integer other$vid = other.getVid();
        if (this$vid == null ? other$vid != null : !((Object)this$vid).equals(other$vid)) {
            return false;
        }
        Integer this$vidType = this.getVidType();
        Integer other$vidType = other.getVidType();
        if (this$vidType == null ? other$vidType != null : !((Object)this$vidType).equals(other$vidType)) {
            return false;
        }
        CouponTemplateBaseInfo this$baseInfo = this.getBaseInfo();
        CouponTemplateBaseInfo other$baseInfo = other.getBaseInfo();
        if (this$baseInfo == null ? other$baseInfo != null : !((Object)this$baseInfo).equals(other$baseInfo)) {
            return false;
        }
        CouponTemplateReduceRule this$reduceRule = this.getReduceRule();
        CouponTemplateReduceRule other$reduceRule = other.getReduceRule();
        if (this$reduceRule == null ? other$reduceRule != null : !((Object)this$reduceRule).equals(other$reduceRule)) {
            return false;
        }
        CouponTemplateSendRule this$sendRule = this.getSendRule();
        CouponTemplateSendRule other$sendRule = other.getSendRule();
        if (this$sendRule == null ? other$sendRule != null : !((Object)this$sendRule).equals(other$sendRule)) {
            return false;
        }
        CouponTemplateUseRule this$useRule = this.getUseRule();
        CouponTemplateUseRule other$useRule = other.getUseRule();
        if (this$useRule == null ? other$useRule != null : !((Object)this$useRule).equals(other$useRule)) {
            return false;
        }
        CouponTemplateOtherSetting this$otherSetting = this.getOtherSetting();
        CouponTemplateOtherSetting other$otherSetting = other.getOtherSetting();
        if (this$otherSetting == null ? other$otherSetting != null : !((Object)this$otherSetting).equals(other$otherSetting)) {
            return false;
        }
        CouponTemplateCreateInfo this$createInfo = this.getCreateInfo();
        CouponTemplateCreateInfo other$createInfo = other.getCreateInfo();
        return !(this$createInfo == null ? other$createInfo != null : !((Object)this$createInfo).equals(other$createInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CouponTemplateReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $vid = this.getVid();
        result = result * 59 + ($vid == null ? 43 : ((Object)$vid).hashCode());
        Integer $vidType = this.getVidType();
        result = result * 59 + ($vidType == null ? 43 : ((Object)$vidType).hashCode());
        CouponTemplateBaseInfo $baseInfo = this.getBaseInfo();
        result = result * 59 + ($baseInfo == null ? 43 : ((Object)$baseInfo).hashCode());
        CouponTemplateReduceRule $reduceRule = this.getReduceRule();
        result = result * 59 + ($reduceRule == null ? 43 : ((Object)$reduceRule).hashCode());
        CouponTemplateSendRule $sendRule = this.getSendRule();
        result = result * 59 + ($sendRule == null ? 43 : ((Object)$sendRule).hashCode());
        CouponTemplateUseRule $useRule = this.getUseRule();
        result = result * 59 + ($useRule == null ? 43 : ((Object)$useRule).hashCode());
        CouponTemplateOtherSetting $otherSetting = this.getOtherSetting();
        result = result * 59 + ($otherSetting == null ? 43 : ((Object)$otherSetting).hashCode());
        CouponTemplateCreateInfo $createInfo = this.getCreateInfo();
        result = result * 59 + ($createInfo == null ? 43 : ((Object)$createInfo).hashCode());
        return result;
    }

    public String toString() {
        return "CouponTemplateReq(vid=" + this.getVid() + ", vidType=" + this.getVidType() + ", baseInfo=" + this.getBaseInfo() + ", reduceRule=" + this.getReduceRule() + ", sendRule=" + this.getSendRule() + ", useRule=" + this.getUseRule() + ", otherSetting=" + this.getOtherSetting() + ", createInfo=" + this.getCreateInfo() + ")";
    }
}

