package com.bizvane.connectorservice.entity.param;

import lombok.Data;

import java.util.List;

@Data
public class OpenCreateTagRequest {

    //标签组 ID，标签组的唯一标识，是商家创建标签组时自动生成得标签组编号。可通过 weimob_cdp/tag/getList 接口获取该 ID。
    private Long tagGroupId;

    //标签组来源。支持的来源包括：0-内部标签；1-企微标签；2-外部标签。
    private Integer source;

    // 标签组名称，商家新增标签组时设置的标签组名称。
    private String tagName;

    //标签组类型。支持的类型包括：1-多选项；2-单选项；3-文本；4-日期；5-数值。
    private Integer tagType;

    //标签组是否仅个人可见。0-全部可见；1-仅个人可见。不传默认为 0。
    private Integer isPersonal;

    // 是否校验标签值与标签名称的非空情况。true-校验；false-不校验。不传默认为 true。
    private Boolean checkTagNameExist;

    //是否创建标签
    private Boolean isAddAtt;

    //签组为已存在的企微标签组。支持的类型包括：true-校验；false-不校验。不填默认为true。
    private Boolean isCheckQwUpdate;

    // 标签信息列表
    private List<TagAttrRequest> tagAttrRequestList;

}
