package com.bizvane.connectorservice.entity.param;

import lombok.Data;

/**
 * 券模板发放规则
 */
@Data
public class CouponTemplateSendRule {

    /**
     * 发放时间类型：1-无限制；2-固定时间。
     * 是否必填：是
     */
    private Integer sendTimeType;

    /**
     * 发放开始时间，格式为时间戳，单位：毫秒。发放时间类型为固定时间时必填。
     * 是否必填：否
     */
    private Long sendStartDate;

    /**
     * 发放结束时间 格式为时间戳，单位：毫秒。发放时间类型为固定时间时必填。
     * 是否必填：否
     */
    private Long sendEndDate;

    /**
     * 是否付费券。true-是；false-不是。非付费券时，发券渠道必传。
     * 是否必填：是
     */
    private Boolean isPayment;

    /**
     * 是否开启客户直接领取发券。true-开启；false-不开启。
     * 是否必填：否
     */
    private Boolean customerDirectReceive;

    /**
     * 是否开启商家发券。true-开启；false-不开启。
     * 是否必填：否
     */
    private Boolean merchantPublish;

    /**
     * 是否开启活动发券。true-开启；false-不开启
     * 是否必填：否
     */
    private Boolean activityPublish;

    /**
     * 是否开启视频号发券渠道。true-开启；false-不开启。
     * 是否必填：否
     */
    private Boolean wechatLiveIssue;

    /**
     * 是否开启企微助手发券。true-开启；false-不开启。
     * 是否必填：否
     */
    private Boolean enterpriseAssistant;

    /**
     * 运费券的配送方式：是否商家配送（仅券类型为运费券填写）。true-是；false-否。
     * 是否必填：否
     */
    private Boolean merchantDelivery;

    /**
     * 运费券的配送方式：是否同城限时达（仅券类型为运费券填写）。true-是；false-否。
     * 是否必填：否
     */
    private Boolean limitedTimeDelivery;

}
