/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.connectorservice.util;

import com.alibaba.fastjson.JSON;
import com.bizvane.connectorservice.util.HttpClientUtil;
import com.bizvane.connectorservice.util.WmSystemTokenUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WmSystemHttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(WmSystemHttpClientUtil.class);
    @Autowired
    private WmSystemTokenUtils tokenUtils;

    public String doPost(String url, String postData) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-type", "application/json;charset=utf-8");
        return this.dopost(url, postData, map);
    }

    public String dopost(String url, String postData, Map<String, String> headers) {
        Map<String, String> params = this.initWmToken();
        return this.dopost(url, postData, headers, params);
    }

    private Map<String, String> initWmToken() {
        HashMap<String, String> params = new HashMap<String, String>();
        String wmSystemToken = this.tokenUtils.getWmSystemToken();
        log.info("initWmToken,wmSystemToken:{}", (Object)wmSystemToken);
        if (StringUtils.isBlank((CharSequence)wmSystemToken)) {
            return params;
        }
        params.put("accesstoken", wmSystemToken);
        return params;
    }

    public String dopost(String url, String postData, Map<String, String> headers, Map<String, String> params) {
        url = this.packingUrl(url, params);
        log.info("CRM -> WM, origin sync url:{}, postData:{}, headers:{}, params:{}", new Object[]{url, postData, null == headers ? "NULL" : JSON.toJSON(headers), null == params ? "NULL" : JSON.toJSONString(params)});
        String result = HttpClientUtil.dopost(url, postData, headers);
        log.info("CRM -> WM, result:{}", (Object)result);
        return result;
    }

    public static <T> T jsonCaseObject(String json, Class<T> targetClass) {
        Object t = JSON.parseObject((String)json, targetClass);
        return (T)t;
    }

    private String packingUrl(String url, Map<String, String> params) {
        url = this.tokenUtils.packingWmSystemInterface(url);
        if (null == params || params.isEmpty()) {
            return url;
        }
        String[] param = new String[params.size()];
        int index = 0;
        for (Map.Entry<String, String> entity : params.entrySet()) {
            param[index] = entity.getKey() + "=" + entity.getValue();
            ++index;
        }
        index = 0;
        for (String s : param) {
            url = index == 0 ? url + "?" + s : url + "&" + s;
        }
        log.info("packingUrl,url:{}", (Object)url);
        return url;
    }
}

