package com.bizvane.connectorservice.enums;


/**
 * CRM 与 微盟字段映射类型枚举
 */
public enum CrmWmFieldMappingTypeEnum {

    /**
     * 券号
     * CRM 券定义编号  ->   微盟的券模板id
     */
    COUPON_CODE(1, "券号"),

    /**
     * 店铺编号
     * CRM 店铺编号 -> 微盟的店铺 vid
     */
    STORE_CODE(2, "店铺"),

    /**
     * 商品编号
     * CRM 商品编号product_code -> 微盟goodsId
     */
    GOODS_CODE(3, "商品"),

    /**
     * 区域编号
     * CRM 伯俊属性编号（prop_code） -> 微盟区域vid
     */
    REGION_CODE(4, "区域"),

    /**
     * 会员标签分组
     * CRM 会员标签分组ID -> 微盟的店铺 vid
     */
    MEMBER_LABEL_GROUP_CODE(5, "会员标签分组"),

    /**
     * 会员标签
     * CRM 会员标签ID -> 微盟的店铺 vid
     */
    MEMBER_LABEL_CODE(6, "会员标签");

    private Integer code;

    private String msg;

    CrmWmFieldMappingTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static String getMsgByCode(Integer code){
        CrmWmFieldMappingTypeEnum moduleTypeEnum = getEnum(code);
        if (moduleTypeEnum == null){
            return "";
        }
        return moduleTypeEnum.getMsg();
    }

    public static CrmWmFieldMappingTypeEnum getEnum(Integer code){
        for (CrmWmFieldMappingTypeEnum type : values()){
            if (code == type.getCode()){
                return type;
            }
        }
        return null;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
