package com.bizvane.connectorservice.entity.req.wm;

import com.bizvane.connectorservice.constant.WmSystemConstant;
import com.bizvane.connectorservice.entity.param.*;
import lombok.Data;

import java.util.List;


/**
 * 卷模板同步入参
 */
@Data
public class CouponTemplateReq {

    /**
     * 组织架构节点 ID。组织的唯一标识，是创建组织时自动生成的 ID，可以通过 bos/organization/getList 接口获取该 ID。
     * 是否必填：否
     */
    private Integer vid;

    /**
     * 组织架构节点类型。类型包括：1-集团；2-品牌；3-区域；4部门；5-商场；6-楼层；10-门店；11-网点；100-自提点。
     * 是否必填：否
     */
    private Integer vidType;

    /**
     * 券模板基础信息
     * 是否必填：是
     */
    private CouponTemplateBaseInfo baseInfo;

    /**
     * 券模板优惠规则
     * 是否必填：是
     */
    private CouponTemplateReduceRule reduceRule;

    /**
     * 券模板发放规则
     * 是否必填：是
     */
    private CouponTemplateSendRule sendRule;

    /**
     * 券模板使用规则
     * 是否必填：是
     */
    private CouponTemplateUseRule useRule;

    /**
     * 模板其他设置
     * 是否必填：是
     */
    private CouponTemplateOtherSetting otherSetting;

    /**
     * 模板创建信息
     * 是否必填：是
     */
    private CouponTemplateCreateInfo  createInfo;


    /**
     * 封装基础信息
     * @param param
     */
    public void buildCouponTemplateBaseInfo(CouponDefinitionParam param){
        this.baseInfo  = new CouponTemplateBaseInfo();
        // 平台类型，类型包括：1-微盟；2-微信；3-支付宝。 固定值 1
        int platformType = 1;
        this.baseInfo  = new CouponTemplateBaseInfo();
        // 优惠券类型，类型包括：1-代金券；2-折扣券；3-兑换券；5-随机金额代金券；9-免运费。
        this.baseInfo.setCouponType(param.getPreferentialType().intValue());
        this.baseInfo.setPlatformType(platformType);
        this.baseInfo.setCouponSubType(packingCouponSubType(param.getUseChannel()));
        // 优惠券名称
        this.baseInfo.setName(param.getCouponName());
        this.baseInfo.setBelongVid(param.getBelongVid());
    }

    /**
     * 券模板优惠规则
     * @param param
     * CRM 优惠券规则分为两种：
     *   1. 现金券
     *   2. 折扣卷
     * 对应微盟系统的代金券和折扣卷
     */
    public void buildCouponTemplateReduceRule(CouponDefinitionParam param){
        // 计价方式，包括：1-市场价；2-销售价；默认销售价 ；兑换券无此字段, 固定值传 2
        int pricingType = 2;
        this.reduceRule  = new CouponTemplateReduceRule();
        this.reduceRule.setPricingType(pricingType);
        // CRM 系统的优惠类型字段 preferentialType： 优惠类型（1现金,2折扣,3兑换,4积分）
        if (param.getPreferentialType() == 1){
            // 现金
            // 减免的类型，包括：0-无门槛固定减免金额；1-固定门槛减免金额；2-每满多少减多少。如果是现金券，固定值传 2
            int reducePriceType = 2;
            this.reduceRule.setReducePriceType(reducePriceType);
            this.reduceRule.setCashTicketAmt(param.getMoney());
        } else if (param.getPreferentialType() == 2) {
            // 折扣
            // 折扣上限类型：1-不封顶；2-按件封顶；3-按金额封顶, 固定值是 3
            int discountLimitType = 3;
            this.reduceRule.setDiscount(param.getDiscount().doubleValue());
            this.reduceRule.setDiscountLimitType(discountLimitType);
            this.reduceRule.setDiscountLimitValue(param.getMaxPreferential().toString());
        }
    }

    /**
     * 封装卷模板发放规则
     * @param param
     */
    public void buildCouponTemplateSendRule(CouponDefinitionParam param){
        // 发放时间类型：1-无限制；2-固定时间。固定值 1
        int sendTimeType = 1;
        // 是否付费券。true-是；false-不是。非付费券时，发券渠道必传。固定值 false
        boolean isPayment = false;
        this.sendRule = new CouponTemplateSendRule();
        this.sendRule.setSendTimeType(sendTimeType);
        this.sendRule.setIsPayment(isPayment);
    }

    /**
     * 封装卷模板使用规则
     * @param param
     */
    public void buildCouponTemplateUseRule(CouponDefinitionParam param){
        // 是否使用有门槛。true-使用；false-不使用。门槛包括满元门槛和满件门槛, 固定值 true
        boolean hasUseThreshold = true;
        // 是否开启满元门槛。true-开启；false-不开启, 固定值 true
        boolean canCashTicket = true;
        // 是否是全部时段可用。true-是；false-不是。 固定值 true
        boolean isAllTimeUse = true;
        // 是否是全部核销场景。true-是；false-不是。 固定值  true
        boolean isAllUseScene = true;
        // 是否开启满件门槛。true-开启；false-不开启。 固定值 false
        boolean canGoodsNumber = false;
        this.useRule = new CouponTemplateUseRule();
        this.useRule.setHasUseThreshold(hasUseThreshold);
        this.useRule.setCanCashTicket(canCashTicket);
        this.useRule.setGoodsCashTicket(param.getMinConsume().intValue());
        // 构建 卷叠加规则
        this.useRule.buildUseRoleSuperpositionRule(param);
        this.useRule.setIsAllTimeUse(isAllTimeUse);
        // 构建 可共享的优惠
        this.useRule.buildUseRoleCanUseDiscount(param);
        this.useRule.setIsAllUseScene(isAllUseScene);
        // 构建 核销场景：商城、堂食、外卖、酒旅，目前只有商城
        this.useRule.buildCouponTemplateAllScene(param);
        // TODO 构建 适用类型信息
        this.useRule.buildUseAcceptTypeDTO(param);
        this.useRule.setCanGoodsNumber(canGoodsNumber);
    }

    /**
     * 封装卷模板其他设置
     * @param param
     */
    public void buildCouponTemplateOtherSetting(CouponDefinitionParam param){
        // 是否为用户打标签。true-打；false-不打。固定值 false
        boolean hasMemberTag = false;
        this.otherSetting = new CouponTemplateOtherSetting();
        this.otherSetting.setExplain(param.getInfo());
        this.otherSetting.setHasMemberTag(hasMemberTag);
    }

    /**
     * 封装模板创建信息
     * @param param
     */
    public void buildCouponTemplateCreateInfo(CouponDefinitionParam param){
        this.createInfo = new CouponTemplateCreateInfo();
        this.createInfo.setOperatorId(WmSystemConstant.WM_STSTEM_OPERATOR_ID);
    }

    /**
     * 封装优惠券子类型：13- 商家券；14-无资金； 11-线上券；12-线下券；默认值为11
     * 全渠道传11， 线下卷传12
     * @return
     */
    private int packingCouponSubType(int useChannel){
        // useChannel 渠道限制（1仅线下,2全渠道,3仅线上,4员工券,5天猫券, 6积分券,7商城私有券）
        if (useChannel == 1){
            return 12;
        }
        return 11;
    }

}
