package com.bizvane.connectorservice.config;


import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * 微盟系统字段默认配置
 */
@Data
@Configuration
public class WMSystemFieldConfig {

    /**
     * 会员方案 ID。可以通过 weimob_crm/membercard/getList 获取该 ID。
     * 测试环境默认值为：800825244
     */
    @Value("${wm.system.field.membershipPlanId:800825244}")
    private String membershipPlanId;

    /**
     * vid, 必传项vid时可使用
     * 测试环境默认为：6015778908054
     */
    @Value("${wm.system.field.vid:6015778908054}")
    private Long vid;

}
