package com.bizvane.connectorservice.interfaces.weimeng;


import com.bizvane.connectorservice.entity.po.SysCrmWmFieldMappingPO;

/**
 * CRM 与 微盟字段映射关系
 */
public interface SysCrmWmFieldMappingService {

    /**
     * 插入CRM 与 微盟字段映射
     * @param entity
     * @return
     */
    Boolean insertSysCrmWmFieldMapping(SysCrmWmFieldMappingPO entity);

    /**
     * 根据crm的字段和类型，查找对应的微盟字段
     * @param crmField
     * @return
     */
    String findWmFieldByCrmField(String crmField, int type);

    /**
     * 根据crm的字段和类型，查找对应的微盟字段, 返回指定类型
     * @param crmField
     * @return
     */
    <T> T findWmFieldByCrmField(String crmField, int type, Class<T> targetClass);

    /**
     * 初始化
     * @param wmField
     * @param crmField
     * @param mappingType
     * @return
     */
    SysCrmWmFieldMappingPO initSysCrmWmFieldMappingPO(String wmField, String crmField, int mappingType);
}
