package com.bizvane.connectorservice.entity.vo.wm;


import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 微盟会员基础信息
 */
@Data
public class WmMemberBaseInfoDto implements Serializable {

    /**
     * 微盟用户wid，客户唯一标识（code，phone，wid不可同时不填）
     */
    private Long wid;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 姓名（非微信昵称）
     */
    private String name;

    /**
     * 生日（时间搓）
     */
    private Long birthday;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 地址
     */
    private String address;

    /**
     * 邮箱
     */
    private String mail;

    /**
     * 性别（1：男； 2：女； 0：未知）
     */
    private Integer sex;

    /**
     * 微信会员卡状态
     */
    private Integer wechatStatus;

    /**
     * 微信会员卡code
     */
    private String wechatCode;

    /**
     * 累计积分
     */
    private Integer totalPoint;

    /**
     * 当前积分（扣掉锁定中）
     */
    private Integer cuurentPoint;

    /**
     * 当前余额（扣掉锁定中）（单位：分）
     */
    private Integer cuurentAmount;

    /**
     * 当前成长值
     */
    private Integer cuurentGrowth;

    /**
     * 会员等级名称
     */
    private String rankName;

    /**
     * 会员等级id
     */
    private Long rankId;

    /**
     * 标签信息
     */
    private List<WmTagVo> tagVoList;


}
