package com.bizvane.connectorservice.entity.req.wm;

import lombok.Data;

import java.util.List;

@Data
public class UpdateMemberStoreReq {

    //B 端操作人的用户 ID
    private Integer operateWid;

    //用户 ID 列表，单次操作最多 20条。可通过 bos/user/search 接口获取 wid。
    private List<Long> widList;

    //绑定场景。描述客户绑定归属门店的原因。支持的绑定场景包括: 1-(导购-扫专属二维码)；2-(领卡)；3-(导购-下单)；
    // 5-(导购-领券)；12-(导购-访问店铺)；13-(企业微信添加外部联系人)；90-(导购换绑)；97-(用户ID合并)；98-(商城领卡)；99-(商家变更)；100-(商家解绑)；101-(买家变更)；102-(买家解绑)。
    private Integer scene;

    //请求来源。 描述该绑定行为请求的来源。支持的请求来源包括: 1-会员；2-导购；3-微客；4-开放平台接入；5-导入；6-用户ID合并。
    private Integer origin;

    //组织架构节点 ID。组织的唯一标识，是创建组织时自动生成的 ID，可以通过 bos/organization/getList 接口获取该 ID。
    private Long vid;

    //变更原因。 字符长度范围为(0,255]。
    private String reason;

}
