package com.bizvane.connectorservice.entity.param;

import lombok.Data;


/**
 * 券模板基础信息
 */
@Data
public class CouponTemplateBaseInfo {

    /**
     * 优惠券类型，类型包括：1-代金券；2-折扣券；3-兑换券；5-随机金额代金券；9-免运费。
     * 是否必填：是
     */
    private Integer couponType;

    /**
     * 平台类型，类型包括：1-微盟；2-微信；3-支付宝。
     * 是否必填：是
     */
    private Integer platformType;

    /**
     * // TODO 待定
     * 优惠券子类型：13- 商家券；14-无资金； 11-线上券；12-线下券；默认值为11。
     * 是否必填：是
     */
    private Object couponSubType;

    /**
     * 优惠券标题
     * 是否必填：是
     */
    private String name;

    /**
     * 券归属
     * 是否必填：是
     */
    private Long belongVid;

    /**
     * 连锁品牌
     * 是否必填：否
     */
    private String merchantName;

}
