package com.bizvane.connectorservice.enums;


/**
 * CRM 与 微盟字段映射类型枚举
 */
public enum CrmWmFieldMappingTypeEnum {

    /**
     * 券号
     * CRM 券定义编号  ->   微盟的券模板id
     */
    COUPON_CODE(1, "券号");


    private Integer code;

    private String msg;

    CrmWmFieldMappingTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static String getMsgByCode(Integer code){
        CrmWmFieldMappingTypeEnum moduleTypeEnum = getEnum(code);
        if (moduleTypeEnum == null){
            return "";
        }
        return moduleTypeEnum.getMsg();
    }

    public static CrmWmFieldMappingTypeEnum getEnum(Integer code){
        for (CrmWmFieldMappingTypeEnum type : values()){
            if (code == type.getCode()){
                return type;
            }
        }
        return null;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
