package com.bizvane.connectorservice.interfaces.out;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.out.huairen.*;

import java.util.List;

/**
 * @author admin
 */
public interface HuaiRenService {

    /**
     * 新增订单
     *
     * @param requestVO
     * @return
     * @throws Exception 异常
     */
    Result<HuaiRenAddOrderResponseVO> addOrder(HuaiRenAddOrderRequestVO requestVO) throws Exception;

    /**
     * 获取库存数
     *
     * @param requestVO
     * @return
     * @throws Exception 异常
     */
    Result<List<HuaiRenGetStocksResponseVO.HuaiRenStockChildVO>> getStocks(HuaiRenGetStocksRequestVO requestVO) throws Exception;

    /**
     * 新增退单
     *
     * @param requestVO
     * @return
     * @throws Exception 异常
     */
    Result<HuaiRenRefundOrderResponseVO> refundOrder(HuaiRenRefundOrderRequestVO requestVO) throws Exception;

    /**
     * 实时查询预提数量
     *
     * @param requestVO
     * @return
     * @throws Exception 异常
     */
    Result<List<HuaiRenGetStorageNumResponseVO>> getStorageNum(HuaiRenGetStorageNumRequestVO requestVO) throws Exception;

    /**
     * 实时查询预提数量
     *
     * @param requestVO
     * @return
     * @throws Exception 异常
     */
    Result<HuaiRenGetHealthResponseVO> getHealth(HuaiRenGetHealthRequestVO requestVO) throws Exception;


}
