package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
/**
 * @author admin
 * @date
 */
@Data
public class AddCouponDefToErpRequestVO extends BaseModel {
    /**
     * 卷类型号
     * */
    private String erpCouponDefinitionCode;

    /**
     * 卷名称
     * */
    private String couponName;

    /**
     * 券类型 现金券=1、折扣券=2
     * */
    private Integer preferentialType;

    /**
     * 折扣购买限制 低于X折不能使用
     * */
    private BigDecimal minDiscount;

    /**
     * 折扣
     * */
    private BigDecimal discount;

    /**
     * 券定义创建时间
     * */
    private String createDate;

    /**
     * 订单满条件 有满减金额1 没有0
     * */
    private Integer minConsumeFlag;

    /**
     * 订单满金额
     * */
    private BigDecimal minConsume;

}
