package com.bizvane.connectorservice.interfaces.jh;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.icrm.*;
import com.bizvane.connectorservice.entity.req.*;
import com.bizvane.connectorservice.util.valid.EnumStringValue;
import org.apache.poi.ss.formula.functions.T;

import java.util.List;

/**
 * @program: connector
 * @description: Crm对接商城接口
 * @author: Liu Xinpeng
 * @create: 2021-03-02 14:53
 **/
public interface CrmJointService {


    /**
     * 券定义
     * @param vgAddCouponDefinitionVo
     * @return
     */
    Result<T> snyCouponInfo(VgAddCouponDefinitionVo vgAddCouponDefinitionVo);

    /**
     * 发券
     * @param couponReqList
     * @return
     */
    Result<T> snyMemberCoupon(List<SnyMemberCouponReq> couponReqList);


    /**
     * 优惠券作废
     * @param vgCancelCouponVo
     * @return
     */
    Result<T> snyCouponStatus(VgCancelCouponVo vgCancelCouponVo);


    /**
     * 优惠券核销
     * @param vgCancelCouponVo
     * @return
     */
    Result<T> snyCouponCancel(VgCancelCouponVo vgCancelCouponVo);


    /**
     * 优惠券转增
     * @param vgAddGiveCouponVo
     * @return
     */
    Result<T> snyCouponTransfer(VgAddGiveCouponVo vgAddGiveCouponVo);

    /**
     * 会员权益
     * @param snyMemberRightsReq
     * @return
     */
    Result<T> snyMemberRights(SnyMemberRightsReq snyMemberRightsReq);



}