package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
/**
 * @author admin
 */
@Data
public class MbrLabelRecordRequestVO extends BaseModel {
    /**
     * 会员卡号
     */
    private String cardNo;

    /**
     * 标签名称（逗号分隔）
     */
    private String labelItem;

    /**
     * 导购code
     */
    private String guideCode;

    /**
     * 打标签时间
     */
    @DateTimeFormat( pattern="yyyy-MM-dd HH:mm:ss")
    private Date labelTime;

    /**
     * 标签操作类型（1帖标签 2撕标签）
     */
    private Integer operateLabelType;

    /**
     * 有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天
     */
    private Byte validType;

    /**
     * 有效天数
     */
    private Integer validDay;

}
