package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.*;
import com.bizvane.connectorservice.entity.hqt.HqCouponTranRequestVO;
import com.bizvane.connectorservice.entity.hqt.HqCouponTranResponseVO;
import com.bizvane.connectorservice.entity.icrm.*;
import com.bizvane.connectorservice.entity.jll.VipInterestsItemListResponseVo;
import com.bizvane.connectorservice.entity.jll.VipInterestsItemRequestVo;
import com.bizvane.connectorservice.entity.jll.VipInterestsRequestVo;
import com.bizvane.connectorservice.entity.jll.VipInterestsResponseVo;
import com.bizvane.connectorservice.entity.vo.IntegralOrderRequestVo;
import com.bizvane.couponfacade.models.vo.CouponStatusUpdateBatchRequestVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * @author liuying
 * @date 2018/8/15
 * @description
 */

@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/rest")
public interface ConnectorServiceFeign {

    /**
     * 调整积分
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "adjustintegral", method = RequestMethod.POST)
    Result<IntegralAdjustResponseVO> adjustIntegral(@RequestBody IntegralAdjustRequestVO requestVO);

    /**
     * 登陆,绑卡
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "login", method = RequestMethod.POST)
    Result<MemberLoginResponseVO> login(@RequestBody MemberLoginRequestVO requestVO);

    /**
     * 线下开卡
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "opencard", method = RequestMethod.POST)
    Result<MemberOpenCardResponseVO> opencard(@RequestBody MemberOpenCardRequestVO requestVO);

    /**
     * 修改手机号
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "modifyphone", method = RequestMethod.POST)
    Result modifyphone(@RequestBody MemberPhoneUpdateRequestVO requestVO);

    /**
     * 单张发券
     * @param requestVo
     * @return
     */
    @RequestMapping(value = "singlecoupon", method = RequestMethod.POST)
    Result singlecoupon(@RequestBody CouponRequestVO requestVo);

    /**
     * 批量发券
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "batchcoupon", method = RequestMethod.POST)
    Result batchcoupon(@RequestBody CouponBatchRequestVO requestVO);

    /**
     * 券转增
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "givecoupon", method = RequestMethod.POST)
    Result givecoupon(@RequestBody CouponGiveRequestVO requestVO);

    /**
     * 券核销
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "usecoupon", method = RequestMethod.POST)
    Result usecoupon(@RequestBody CouponUseRequestVO requestVO);

    /**
     * 新增线下订单
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "addorder", method = RequestMethod.POST)
    Result addorder(@RequestBody OrderAddRequestVO requestVO);

    /**
     * 新增线下退单（按详情退）
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "refundorder", method = RequestMethod.POST)
    Result refundOrder(@RequestBody OrderRefundRequestVO requestVO);


    /**
     * 新增退货退款单
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "refundgoods", method = RequestMethod.POST)
    Result refundGoods(@RequestBody OrderRefundGoodsRequestVO requestVO);

    /**
     * 修改支付密码接口
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "modifypaymentpassword", method = RequestMethod.POST)
    Result modifyPaymentPassword(@RequestBody PaymentPasswordRequestVO requestVO);


    /**
     * 批量线下券绑定
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "batchcouponbind", method = RequestMethod.POST)
    Result batchCouponBind(@RequestBody CouponBatchBindRequestVO requestVO);

    /**
     * 单张线下券绑定
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "singlecouponbind", method = RequestMethod.POST)
    Result singleCouponBind(@RequestBody CouponBindRequestVO requestVO);

    /**
     * 会员升降级
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "modifymembergrade", method = RequestMethod.POST)
    Result modifyMemberGrade(@RequestBody MemberModifyGradeRequestVO requestVO);


    /**
     *新增充值记录信息
     * @param requestVO
     * @return
     */
    @RequestMapping(value="rechargerecord",method = RequestMethod.POST)
    Result<RechargeRecordResponseVO> rechargeRecord(@RequestBody RechargeRecordRequestVO requestVO);

    /**
     *储值卡金额扣减
     * @param requestVO
     * @return
     */
    @RequestMapping(value="deductionbalance",method = RequestMethod.POST)
   Result deductionbalance(@RequestBody DeductionbalanceRequestVO requestVO);

    /**
     * 修改个人资料
     * @param requestVO
     * @return
     */
    @RequestMapping(value="updateuserinfo",method = RequestMethod.POST)
    Result updateUseInfo(@RequestBody MemberInfoUpdateRequestVO requestVO);


    /**
     *储值卡转赠消费记录批量保存接口
     * @param requestVO
     * @return
     */
    @RequestMapping(value="batchsavestoragecard",method = RequestMethod.POST)
    Result batchSaveStorageCard(@RequestBody StorageCardListRequestVO requestVO);


    /**
     *礼品卡消费记录批量保存接口
     * @param requestVO
     * @return
     */
    @RequestMapping(value="batchsavegiftcarddetail",method = RequestMethod.POST)
    Result batchSaveGiftCardDetail(@RequestBody GiftCardListRequestVO requestVO);


    /**
     * 线下会员信息查询接口
     * @param requestVO
     * @return
     */
    @RequestMapping(value="querymemberinfo",method = RequestMethod.POST)
    Result<MemberInfoQueryResponseVO> queryMemberInfo(@RequestBody MemberInfoQueryRequestVO requestVO);

    /**
     * 已发货订单写线下
     * @param requestVO
     * @return
     */
    @RequestMapping(value="addsendedorder",method = RequestMethod.POST)
    Result addSendedOrder(@RequestBody OrderAddSendedRequestVO requestVO);


    /**
     * 线下会员积分流水查询接口
     * @param requestVO
     * @return
     */
    @RequestMapping(value="getintegrallist",method = RequestMethod.POST)
    Result<IntegralListResponseVO> getIntegralList(@RequestBody IntegralListRequestVO requestVO);


    /**
     * 员工离职
     * @param requestVO
     * @return
     */
    @RequestMapping(value="guideinvalid",method = RequestMethod.POST)
    Result guideinvalid(@RequestBody GuideInvalidRequestVO requestVO);

    /**
     * 员工调店
     * @param requestVO
     * @return
     */
    @RequestMapping(value="guideupdatestore",method = RequestMethod.POST)
    Result guideupdatestore(@RequestBody GuideUpdateStoreRequestVO requestVO);

    /**
     * 修改会员导购
     * @param requestVO
     * @return
     */
    @RequestMapping(value="modifyuserguide",method = RequestMethod.POST)
    Result modifyuserguide(@RequestBody UserUpdateGuideRequestVO requestVO);

    /**
     *阿里绑定调线下
     * @param requestVO
     * @return
     */
    @RequestMapping(value="tmallbindtoerp",method = RequestMethod.POST)
    Result tmallBindToErp(@RequestBody MemberBindToErpRequestVO requestVO);

    /**
     * 登陆,绑卡
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "loginandopencard", method = RequestMethod.POST)
    Result<MemberOpenCardResponseVO> loginandopencard(@RequestBody MemberOpenCardRequestVO requestVO);

    /**
     * 批量发券(同步)
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "batchcouponsync", method = RequestMethod.POST)
    Result<CouponStatusUpdateBatchRequestVO> batchcouponsync(@RequestBody CouponBatchRequestVO requestVO);

    /**
     * 单张发券(同步)
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "singlecouponsync", method = RequestMethod.POST)
    Result<SingleCouponSyncVo> singleCouponSync(@RequestBody CouponRequestVO requestVO);

    /**
     * 单张线下券绑定(同步)
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "singlecouponbindsync", method = RequestMethod.POST)
    Result<SingleCouponBindSyncVo> singleCouponBindSync(@RequestBody CouponBindRequestVO requestVO);

    /**
     * 批量线下券绑定(同步)
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "batchcouponbindsync", method = RequestMethod.POST)
    Result<CouponStatusUpdateBatchRequestVO> batchCouponBindSync(@RequestBody CouponBatchBindRequestVO requestVO);

    /**
     * 券冲正
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "cancelusecoupon", method = RequestMethod.POST)
    Result cancelUseCoupon(CouponCancelRequestVO requestVO);


    /**
     * 批量员工券发券(同步)
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "batchempcouponsync", method = RequestMethod.POST)
    Result<CouponStatusUpdateBatchRequestVO> batchEmpCouponSync(@RequestBody CouponBatchRequestVO requestVO);

    /**
     * 退款
     * @param requestVO
     * @return
     */
    @PostMapping(value = "refundrechargerecord", produces  = MediaType.APPLICATION_JSON_VALUE)
    Result<String> refundRechargeRecord(@RequestBody RefundRechargeRecordRequestVo requestVO);


    /**
     *储蓄卡消费记录
     * @param requestVO
     * @return
     */
    @PostMapping(value = "debitcardconsumerecord", produces  = MediaType.APPLICATION_JSON_VALUE)
    Result<String> debitCardConsume(DebitCardConsumeRequestVo requestVO);

    /**
     * 储值卡转赠
     * @param requestVO
     * @return
     */
    @PostMapping(value = "rechargecardgive", produces = MediaType.APPLICATION_JSON_VALUE)
    Result<String> rechargeCardGive(@RequestBody RechargeCardGiveRequestVo requestVO);

    /**
     * 储值卡转赠更新
     * @param requestVO
     * @return
     */
    @PostMapping(value = "updaterechargecardgive", produces = MediaType.APPLICATION_JSON_VALUE)
    Result<String> updateRechargeCardGive(@RequestBody RechargeCardGiveRequestVo requestVO);

    /**
     * 保存大中小类商品
     * bigCategory-券code    bigCategory-券code  bigCategory-券code
     * middleCategory-券id    middleCategory-券id   smallCategory-券id
     * @param key
     * @param value
     * @return
     */
    @RequestMapping(value = "saveCategory", method = RequestMethod.POST)
    void saveCategory(@RequestParam("key") String key, @RequestParam("value") String value);

    /**
     * [标准积分订单]积分订单同步
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "addIntegralOrder", produces = MediaType.APPLICATION_JSON_VALUE)
    Result<String> addIntegralOrder(@RequestBody IntegralOrderRequestVo requestVO);

    /**
     * [标准积分订单]订单支付
     * @param requestVO
     */
    @PostMapping("integralOrderPayed")
    Result<String> orderPayed(@RequestBody IntegralOrderRequestVo requestVO);

    /**
     * [标准积分订单]订单发货
     * @param requestVO
     */
    @PostMapping("integralOrderShippped")
    Result<String> orderShippped(@RequestBody IntegralOrderRequestVo requestVO);

    /**
     * [标准积分订单]订单收货签收
     * @param requestVO
     */
    @PostMapping("integralOrderReceipted")
    Result<String> orderReceipted(@RequestBody IntegralOrderRequestVo requestVO);

    /**
     * [标准积分订单]订单售后单创建(此时待发货)
     * @param requestVO
     */
    @PostMapping("integralOrderAftersaleUnshippped")
    Result<String> orderAftersaleUnshippped(@RequestBody IntegralOrderRequestVo requestVO);

    /**
     * [标准积分订单]订单售后(售后已寄回)
     * @param requestVO
     */
    @PostMapping("integralOrderAftersaleShippped")
    Result<String> orderAftersaleShippped(@RequestBody IntegralOrderRequestVo requestVO);

    /**
     * [标准积分订单]订单售后寄回已签收
     * @param requestVO
     */
    @PostMapping("integralOrderAftersaleReceipted")
    Result<String> orderAftersaleReceipted(@RequestBody IntegralOrderRequestVo requestVO);

    /**
     * 金利来
     * 查询活动具体信息
     * @param requestVO
     * @return
     * */
    @RequestMapping(value = "getactinformation",method = RequestMethod.POST)
    Result<VipInterestsResponseVo> getActInformation(@RequestBody VipInterestsRequestVo requestVO);

    /**
     * 金利来
     * 查询会员满足权益
     * @param requestVO
     * @return
     * */
    @RequestMapping(value = "getvipinterequity", method = RequestMethod.POST)
    Result<VipInterestsItemListResponseVo> getVipInterEquity(@RequestBody VipInterestsItemRequestVo requestVO);

    /**
     * 金利来
     * 会员打标签
     * @param requestVO
     * @return
     */
    @PostMapping(value = "mbrlabelrecord", produces = MediaType.APPLICATION_JSON_VALUE)
    Result<String> mbrLabelRecord(@RequestBody MbrLabelRecordRequestVO requestVO);

    /**
     * jeep
     * 定义优惠卷写线下
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "addcoupondeftoerp", method = RequestMethod.POST)
    Result addCouponDefToErp(@RequestBody AddCouponDefToErpRequestVO requestVO);

    /**
     * 红蜻蜓
     * 卷转换规则校验
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "couponcardcheck", method = RequestMethod.POST)
    Result<HqCouponTranResponseVO> couponCardCheck(@RequestBody HqCouponTranRequestVO requestVO);

    /**
     * UR 更新储蓄卡消费记录
     * @param requestVO
     * @return
     */
    @PostMapping(value = "updateConsumeRecord", produces = MediaType.APPLICATION_JSON_VALUE)
    Result<String> updateConsumeRecord(DebitCardConsumeRequestVo requestVO);

}
