package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author xz
 * @date 2019/12/19 15:19
 **/


public class DebitCardConsumeRequestVo extends BaseModel {
    /**
     * 储蓄卡号
     */
    private String debitCardNo;

    /**
     * 会员卡号
     */
    private String memberCardCode;

    /**
     * 会员code
     */
    private String memberCode;

    /**
     * 变更本金金额
     */
    private BigDecimal changeAmount;

    /**
     * 变更赠送金额
     */
    private BigDecimal changeGiveAmount;

    /**
     * 变更转赠本金金额
     */
    private BigDecimal changeAmountGift;

    /**
     * 变更转赠赠送金额
     */
    private BigDecimal changeGiveAmountGift;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 操作人code
     */
    private String userCode;

    /**
     * 类型 1:订单退货  4:消费订单',
     */
    private Integer type;

    /**
     * 下单时间
     */
    @DateTimeFormat( pattern="yyyy-MM-dd HH:mm:ss")
    private Date orderTime;

    /**
     * 储值卡余额调整接口标志
     * */
    private String flagInterface;

    /**
     * 流水号
     * */
    private String recordNo;

    /**
     * 支付时间
     * */
    @DateTimeFormat( pattern="yyyy-MM-dd HH:mm:ss")
    private Date billsDate;

    /**
     * 当前本金总额
     */
    private BigDecimal currentAmount;

    /**
     * 当前赠送金额总余额
     */
    private BigDecimal currnentGiveAmount;

    /**
     * 新订单号
     */
    private String newOrderNo;

    /**
     * 中间库流水ID
     * */
    private String midConsumeId;

    public String getMidConsumeId() {
        return midConsumeId;
    }

    public void setMidConsumeId(String midConsumeId) {
        this.midConsumeId = midConsumeId;
    }

    public String getNewOrderNo() {
        return newOrderNo;
    }

    public void setNewOrderNo(String newOrderNo) {
        this.newOrderNo = newOrderNo;
    }

    public BigDecimal getCurrentAmount() {
        return currentAmount;
    }

    public void setCurrentAmount(BigDecimal currentAmount) {
        this.currentAmount = currentAmount;
    }

    public BigDecimal getCurrnentGiveAmount() {
        return currnentGiveAmount;
    }

    public void setCurrnentGiveAmount(BigDecimal currnentGiveAmount) {
        this.currnentGiveAmount = currnentGiveAmount;
    }

    public Date getBillsDate() {
        return billsDate;
    }

    public void setBillsDate(Date billsDate) {
        this.billsDate = billsDate;
    }

    public String getRecordNo() {
        return recordNo;
    }

    public void setRecordNo(String recordNo) {
        this.recordNo = recordNo;
    }

    public String getFlagInterface() {
        return flagInterface;
    }

    public void setFlagInterface(String flagInterface) {
        this.flagInterface = flagInterface;
    }

    public String getDebitCardNo() {
        return debitCardNo;
    }

    public void setDebitCardNo(String debitCardNo) {
        this.debitCardNo = debitCardNo;
    }

    public String getMemberCardCode() {
        return memberCardCode;
    }

    public void setMemberCardCode(String memberCardCode) {
        this.memberCardCode = memberCardCode;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public BigDecimal getChangeAmount() {
        return changeAmount;
    }

    public void setChangeAmount(BigDecimal changeAmount) {
        this.changeAmount = changeAmount;
    }

    public BigDecimal getChangeGiveAmount() {
        return changeGiveAmount;
    }

    public void setChangeGiveAmount(BigDecimal changeGiveAmount) {
        this.changeGiveAmount = changeGiveAmount;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public BigDecimal getChangeAmountGift() {
        return changeAmountGift;
    }

    public void setChangeAmountGift(BigDecimal changeAmountGift) {
        this.changeAmountGift = changeAmountGift;
    }

    public BigDecimal getChangeGiveAmountGift() {
        return changeGiveAmountGift;
    }

    public void setChangeGiveAmountGift(BigDecimal changeGiveAmountGift) {
        this.changeGiveAmountGift = changeGiveAmountGift;
    }
}
