package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author liuying
 * @date 2018/8/9
 * @description
 */
@Data
public class IntegralAdjustRequestVO  extends BaseModel {


    /**
     * 订单编号
     */
    private String orderBillNo;

    /**
     * 线下卡号   361必填
     */
    @NotBlank(message = "卡号不允许为空")
    private String offlineCardNo;

    /**
     * 调整积分数量  361必填
     */
    @NotNull(message = "调整积分不允许为空")
    private Integer changeIntegral;

    /**
     * 调整类型
     */
    private Integer changeType;

    /**
     * 业务类型(统一定义)
     */
    private String businessType;

    /**
     * 调整详情
     */
    private String detail;

    /**
     * 所属门店UR
     */
    private String  storeId;
    /**
     * 积分数额UR
     */
    private Double pointsAmount;

    /**
     * 来源 UR  361必填为999
     */
    @NotBlank(message = "积分来源不允许为空")
    private String  source;

    /**
     * 关联积分流水id
     */
    private String relationPointsIdUnique;

    /**
     * 积分流水id防重 UR
     */
    private String pointsIdUnique;

    /**
     * 以下为361 加的字段
     */
    /**
     * 关联单据
     */
    private String relationCode;

    /**
     *	新增时间
     * @return
     */
    private String addTime;

    /**
     * 顾客代码
     */
    private String erpId;

    /**
     * 渠道
     */
    private String orgCode;

    /**
     * 店铺code
     */
    private String shopCode;

    /**
     * 兑换的优惠券号
     */
    private String  couponCode;

    /**
     * 产生类型
     */
    private String createType;


    /**
     * 会员淘宝Nick
     * */
    private String taobaoNick;

    /**
     * linkflow
     * 积分唯一流水号
     * */
    @NotBlank(message = "积分唯一流水号不允许为空")
    private String serialNumber;

    @ApiModelProperty(name = "changeDetails", value = "开启负积分")
    private Boolean enableNegativeIntegral = Boolean.FALSE;

    @ApiModelProperty(name = "changeDetails", value = "开启线下积分幂等")
    private Boolean enableIdempotentIntegral = Boolean.FALSE;

    @ApiModelProperty(name = "changeDetails", value = "开启补偿积分")
    private Boolean enableCompensateIntegral = Boolean.FALSE;

}
