package com.bizvane.connectorservice.entity.zds.pos;

import com.bizvane.connectorservice.entity.base.ZdsBaseModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zcc
 * @date 2022/10/18 15:27
 *
 * 区域能力请求vo
 **/

@Data
public class AreaDimensionRequestVo extends ZdsBaseModel implements Serializable {
    private static final long serialVersionUID = 6189476627822852223L;

    /**
     * 门店编码
     * 必传
     */
    private List<String> orgCodes;

    /**
     * 开始日期 yyyy-MM-dd
     * 必传
     */
    private String startDate;

    /**
     * 结束日期 yyyy-MM-dd
     * 必传
     */
    private String endDate;

    /**
     * 微信订单开始时间 yyyy-MM-dd HH:mm:ss
     * 必传
     */
    private String wxStartTime;

    /**
     * 微信订单结束时间 yyyy-MM-dd HH:mm:ss
     * 必传
     */
    private String wxEndTime;

}
