package com.bizvane.connectorservice.entity.zds.pos;

import com.bizvane.connectorservice.entity.base.ZdsBaseModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zcc
 * @date 2022/10/18 16:01
 *
 * 员工列表业绩请求vo
 **/

@Data
public class StaffRankRequestVo extends ZdsBaseModel implements Serializable {
    private static final long serialVersionUID = 8030573175661759450L;

    /**
     * 每页返回行数(默认10行)
     */
    private Integer size;

    /**
     * 请求页数(默认为第1页)
     */
    private Integer current;

    /**
     * 门店编码
     * 必传
     */
    private List<String> orgCodes;

    /**
     * 开始日期 yyyy-MM-dd
     * 必传
     */
    private String startDate;

    /**
     * 结束日期 yyyy-MM-dd
     * 必传
     */
    private String endDate;

}
