/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.connectorservice.util;

import com.bizvane.connectorservice.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtils {
    private static Logger log = LoggerFactory.getLogger((String)RestUtils.class.getName());
    private static final int TIME_OUT = 8000;

    public static String sendRequest_buff(String apiURL, String params, String method) throws Exception {
        return RestUtils.sendRequest_buff(apiURL, params, method, false);
    }

    public static String sendRequest_buff(String apiURL, String params, String method, boolean keepAlive) throws Exception {
        return RestUtils.sendRequest_buff(apiURL, params, null, method, keepAlive);
    }

    public static String sendRequest_buff(String url, String params, JSONObject head, String method, boolean keepAlive) throws Exception {
        if (head == null) {
            head = new JSONObject();
        }
        log.info("url->" + url);
        if (StringUtil.isNotNull(params)) {
            log.info("params :" + (params.length() > 3000 ? params.substring(0, 3000) : params));
        }
        method = StringUtil.valueOf(method, "POST");
        log.info("sendRequest_buff params:" + params);
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod(method.toUpperCase());
        String key = null;
        Iterator headKeys = head.keys();
        while (headKeys.hasNext()) {
            key = (String)headKeys.next();
            conn.setRequestProperty(key, head.optString(key));
        }
        if (keepAlive) {
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setConnectTimeout(60000);
        } else {
            conn.setConnectTimeout(8000);
        }
        conn.setDoInput(true);
        if ("post".equalsIgnoreCase(method)) {
            conn.setUseCaches(false);
        }
        if (StringUtil.isNotNull(params)) {
            conn.setDoOutput(true);
            conn.getOutputStream().write(params.getBytes("utf-8"));
        }
        conn.connect();
        log.info(RestUtils.toCustomString(conn.getHeaderFields()));
        if (conn.getResponseCode() != 200) {
            log.error("server status->" + conn.getResponseCode());
            throw new Exception("\u8bf7\u6c42url\u5931\u8d25");
        }
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        bis = new BufferedInputStream(conn.getInputStream());
        int len = 0;
        while ((len = bis.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        log.info("chareset:" + conn.getContentType());
        String charset = RestUtils.getChareset(conn.getContentType());
        String resultString = baos.toString(charset);
        conn.disconnect();
        log.info("RestUtils result-->" + resultString);
        return resultString;
    }

    public static String getChareset(String contentType) {
        int i = contentType == null ? -1 : contentType.indexOf("charset=");
        return i == -1 ? "UTF-8" : contentType.substring(i + 8);
    }

    private static String toCustomString(Map ht) {
        String LINE_SEPARATOR = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        for (Object key : ht.keySet()) {
            Object v = ht.get(key);
            if (v == null) {
                buf.append(key + ":=" + null + LINE_SEPARATOR);
                break;
            }
            if (v instanceof Collection) {
                v = RestUtils.toString(((Collection)v).toArray());
            } else if (v.getClass().isArray()) {
                v = RestUtils.toString((Object[])v);
            }
            buf.append(key + ":=" + v + LINE_SEPARATOR);
        }
        return buf.toString();
    }

    public static String toString(Object[] s) {
        block6: {
            if (s != null && s.length != 0) break block6;
            return "null";
        }
        try {
            if (s.length == 1) {
                return "" + s[0];
            }
            String ret = "";
            int i = 0;
            while (i < s.length - 1) {
                if (s[i].getClass().isArray()) {
                    ret = String.valueOf(ret) + RestUtils.toString((Object[])s[i]) + ",";
                }
                ret = String.valueOf(ret) + s[i] + ",";
                ++i;
            }
            ret = String.valueOf(ret) + s[s.length - 1];
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "internal error";
        }
    }
}

