package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.zds.*;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/zds")
public interface ZdsConnectorServiceFeign {

    /**
     * 券定义 详情 查询
     * @param couponDefinitionCode
     * @return
     */
    @PostMapping("/getCouponDefinitionInfo")
    Result<ZdsCouponDefinition> getCouponDefinitionInfo(@RequestParam("couponDefinitionCode") String couponDefinitionCode, @RequestParam("brandId") Long brandId);

    /**
     * 券定义 列表/分页 查询
     * @param requestVo
     * @return
     */
    @PostMapping("/getCouponDefinitionList")
    Result<PageInfo<ZdsCouponDefinition>> getCouponDefinitionList(@RequestBody CouponDefinitionListRequestVo requestVo);

    /**
     * 券实体 详情 查询
     * @param couponCode
     * @return
     */
    @PostMapping("/getCouponInfo")
    Result<ZdsCouponInfo> getCouponInfo(@RequestParam("couponCode")String couponCode,@RequestParam("brandId")Long brandId);

    /**
     * 券实体 列表/分页 查询
     * @param requestVo
     * @return
     */
    @PostMapping("/getCouponList")
    Result<PageInfo<ZdsCouponInfo>> getCouponList(@RequestBody CouponEntityListRequestVo requestVo);

    /**
     * 会员券数量统计
     * @param erpId
     * @return
     */
    @PostMapping("/getCouponCountByErpId")
    Result<CouponCountResponseVo> getCouponCountByErpId(@RequestParam("erpId") String erpId,@RequestParam("brandId")Long brandId);

    /**
     * 单张发券
     * @param requestVo
     * @return
     */
    @PostMapping("/singleCoupon")
    Result singleCoupon(@RequestBody SingleCouponRequestVo requestVo);

    /**
     * 批量发券
     * @param requestVo
     * @return
     */
    @PostMapping("/BatchCoupon")
    Result BatchCoupon(@RequestBody BatchCouponRequestVo requestVo);

    /**
     * 获取 发送短信二维码
     * @param requestVo
     * @return
     */
    @PostMapping("/sendSmsMessage")
    Result sendSmsMessage(@RequestBody SmsMessageRequestVo requestVo);

    /**
     * 员工离职
     * @param requestVo
     * @return
     */
    @PostMapping("/guideInvalid")
    Result guideInvalid(@RequestBody ZdsGuideInvalidRequestVo requestVo);

    /**
     * 店长分配会员所属关系接口
     * @param requestVo
     * @return
     */
    @PostMapping("/assignMembers")
    Result assignMembers(@RequestBody MemberInfoReuqestVo requestVo);

    /**
     * 小程序码生成接口
     * @param requestVo
     * @return
     */
    @PostMapping("/GenerateQrCode")
    Result<String> GenerateQrCode(@RequestBody QrCodeRequestVo requestVo);
}
