package com.bizvane.connectorservice.interfaces.online;

import com.bizvane.connectorservice.entity.po.ConnectMethodConfig;

/**
 * @author liuying
 * @date 2018/8/29
 * @description
 */

public interface ConnectMethodConfigService {

    /**
     * 根据redis中ConnectConfig数据获取品牌,按品牌从db加载t_connect_method_config表进redis
     */
    void refreshRedisAll();

    /**
     * 根据onlineBrandId + methodName 获取ConnectMethodConfig对象
     * @param onlineBrandId
     * @param methodName
     * @return
     */
    ConnectMethodConfig getConnectMethodConfigByOnlineBrandIdAndMethodName(Long onlineBrandId, String methodName);

    void deleteRedis(Long onlineBrandId);
}
