package com.bizvane.connectorservice.interfaces.zhoudasheng;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.zds.*;
import com.github.pagehelper.PageInfo;

public interface ZdsService {

    /**
     * 券定义 详情 查询
     * @param couponDefinitionId
     * @param brandId
     * @return
     */
    Result<ZdsCouponDefinition> getCouponDefinitionInfo(String couponDefinitionId,Long brandId);

    /**
     * 券定义 列表/分页 查询
     * @param requestVo
     * @return
     */
    Result<PageInfo<ZdsCouponDefinition>> getCouponDefinitionList(CouponDefinitionListRequestVo requestVo);

    /**
     * 券实体 详情 查询
     * @param couponCode
     * @param brandId
     * @return
     */
    Result<ZdsCouponInfo> getCouponInfo(String couponCode,Long brandId);

    /**
     * 券实体 列表/分页 查询
     * @param requestVo
     * @return
     */
    Result<PageInfo<ZdsCouponInfo>> getCouponList(CouponEntityListRequestVo requestVo);

    /**
     * 会员券数量统计
     * @param erpId
     * @return
     */
    Result<CouponCountResponseVo> getCouponCountByCardNo(String erpId,Long brandId);

    /**
     * 单张发券
     * @param requestVo
     * @return
     */
    Result singleCoupon(SingleCouponRequestVo requestVo);

    /**
     * 批量发券
     * @param requestVo
     * @return
     */
    Result BatchCoupon(BatchCouponRequestVo requestVo);

    /**
     * 发送短信
     * @param requestVo
     * @return
     */
    Result sendSmsMessage(SmsMessageRequestVo requestVo);

    /**
     * 员工离职
     * @param requestVo
     * @return
     */
    Result guideInvalid(ZdsGuideInvalidRequestVo requestVo);

    /**
     * 店长分配会员所属关系接口
     * @param requestVo
     * @return
     */
    Result assignMembers(MemberInfoReuqestVo requestVo);

    /**
     * 小程序码生成接口
     * @param requestVo
     * @return
     */
    Result<String> GenerateQrCode(QrCodeRequestVo requestVo);

}
